/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.camera.core.ImageCapture;
import androidx.camera.core.ImageReaderProxyProvider;
import androidx.camera.core.impl.CaptureBundle;
import androidx.camera.core.impl.CaptureProcessor;
import androidx.camera.core.impl.Config;
import androidx.camera.core.impl.ImageOutputConfig;
import androidx.camera.core.impl.OptionsBundle;
import androidx.camera.core.impl.UseCaseConfig;
import androidx.camera.core.internal.IoConfig;
import java.util.concurrent.Executor;

public final class ImageCaptureConfig
implements UseCaseConfig<ImageCapture>,
ImageOutputConfig,
IoConfig {
    public static final Config.Option<Integer> OPTION_IMAGE_CAPTURE_MODE = Config.Option.create("camerax.core.imageCapture.captureMode", Integer.TYPE);
    public static final Config.Option<Integer> OPTION_FLASH_MODE = Config.Option.create("camerax.core.imageCapture.flashMode", Integer.TYPE);
    public static final Config.Option<CaptureBundle> OPTION_CAPTURE_BUNDLE = Config.Option.create("camerax.core.imageCapture.captureBundle", CaptureBundle.class);
    public static final Config.Option<CaptureProcessor> OPTION_CAPTURE_PROCESSOR = Config.Option.create("camerax.core.imageCapture.captureProcessor", CaptureProcessor.class);
    public static final Config.Option<Integer> OPTION_BUFFER_FORMAT = Config.Option.create("camerax.core.imageCapture.bufferFormat", Integer.class);
    public static final Config.Option<Integer> OPTION_MAX_CAPTURE_STAGES = Config.Option.create("camerax.core.imageCapture.maxCaptureStages", Integer.class);
    public static final Config.Option<ImageReaderProxyProvider> OPTION_IMAGE_READER_PROXY_PROVIDER = Config.Option.create("camerax.core.imageAnalysis.imageReaderProxyProvider", ImageReaderProxyProvider.class);
    private final OptionsBundle mConfig;

    public ImageCaptureConfig(@NonNull OptionsBundle config) {
        this.mConfig = config;
    }

    @Override
    @NonNull
    public Config getConfig() {
        return this.mConfig;
    }

    public boolean hasCaptureMode() {
        return this.containsOption(OPTION_IMAGE_CAPTURE_MODE);
    }

    public int getCaptureMode() {
        return this.retrieveOption(OPTION_IMAGE_CAPTURE_MODE);
    }

    public int getFlashMode() {
        return this.retrieveOption(OPTION_FLASH_MODE);
    }

    @Nullable
    public CaptureBundle getCaptureBundle(@Nullable CaptureBundle valueIfMissing) {
        return this.retrieveOption(OPTION_CAPTURE_BUNDLE, valueIfMissing);
    }

    @NonNull
    public CaptureBundle getCaptureBundle() {
        return this.retrieveOption(OPTION_CAPTURE_BUNDLE);
    }

    @Nullable
    public CaptureProcessor getCaptureProcessor(@Nullable CaptureProcessor valueIfMissing) {
        return this.retrieveOption(OPTION_CAPTURE_PROCESSOR, valueIfMissing);
    }

    @NonNull
    public CaptureProcessor getCaptureProcessor() {
        return this.retrieveOption(OPTION_CAPTURE_PROCESSOR);
    }

    @Nullable
    public Integer getBufferFormat(@Nullable Integer valueIfMissing) {
        return this.retrieveOption(OPTION_BUFFER_FORMAT, valueIfMissing);
    }

    @NonNull
    public Integer getBufferFormat() {
        return this.retrieveOption(OPTION_BUFFER_FORMAT);
    }

    @Override
    public int getInputFormat() {
        return (Integer)this.retrieveOption(OPTION_INPUT_FORMAT);
    }

    public int getMaxCaptureStages(int valueIfMissing) {
        return this.retrieveOption(OPTION_MAX_CAPTURE_STAGES, valueIfMissing);
    }

    public int getMaxCaptureStages() {
        return this.retrieveOption(OPTION_MAX_CAPTURE_STAGES);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public ImageReaderProxyProvider getImageReaderProxyProvider() {
        return this.retrieveOption(OPTION_IMAGE_READER_PROXY_PROVIDER, null);
    }

    @Override
    @Nullable
    public Executor getIoExecutor(@Nullable Executor valueIfMissing) {
        return this.retrieveOption(OPTION_IO_EXECUTOR, valueIfMissing);
    }

    @Override
    @NonNull
    public Executor getIoExecutor() {
        return (Executor)this.retrieveOption(OPTION_IO_EXECUTOR);
    }
}

