/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl;

import android.util.Pair;
import android.util.Rational;
import android.util.Size;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.core.AspectRatio;
import androidx.camera.core.impl.Config;
import androidx.camera.core.impl.ReadableConfig;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;

public interface ImageOutputConfig
extends ReadableConfig {
    public static final Rational DEFAULT_ASPECT_RATIO_LANDSCAPE = new Rational(4, 3);
    public static final Rational DEFAULT_ASPECT_RATIO_PORTRAIT = new Rational(3, 4);
    public static final int INVALID_ROTATION = -1;
    public static final Config.Option<Rational> OPTION_TARGET_ASPECT_RATIO_CUSTOM = Config.Option.create("camerax.core.imageOutput.targetAspectRatioCustom", Rational.class);
    public static final Config.Option<Integer> OPTION_TARGET_ASPECT_RATIO = Config.Option.create("camerax.core.imageOutput.targetAspectRatio", AspectRatio.class);
    public static final Config.Option<Integer> OPTION_TARGET_ROTATION = Config.Option.create("camerax.core.imageOutput.targetRotation", Integer.TYPE);
    public static final Config.Option<Size> OPTION_TARGET_RESOLUTION = Config.Option.create("camerax.core.imageOutput.targetResolution", Size.class);
    public static final Config.Option<Size> OPTION_DEFAULT_RESOLUTION = Config.Option.create("camerax.core.imageOutput.defaultResolution", Size.class);
    public static final Config.Option<Size> OPTION_MAX_RESOLUTION = Config.Option.create("camerax.core.imageOutput.maxResolution", Size.class);
    public static final Config.Option<List<Pair<Integer, Size[]>>> OPTION_SUPPORTED_RESOLUTIONS = Config.Option.create("camerax.core.imageOutput.supportedResolutions", List.class);

    @Nullable
    default public Rational getTargetAspectRatioCustom(@Nullable Rational valueIfMissing) {
        return this.retrieveOption(OPTION_TARGET_ASPECT_RATIO_CUSTOM, valueIfMissing);
    }

    @NonNull
    default public Rational getTargetAspectRatioCustom() {
        return this.retrieveOption(OPTION_TARGET_ASPECT_RATIO_CUSTOM);
    }

    default public boolean hasTargetAspectRatio() {
        return this.containsOption(OPTION_TARGET_ASPECT_RATIO);
    }

    default public int getTargetAspectRatio() {
        return this.retrieveOption(OPTION_TARGET_ASPECT_RATIO);
    }

    default public int getTargetRotation(int valueIfMissing) {
        return this.retrieveOption(OPTION_TARGET_ROTATION, valueIfMissing);
    }

    default public int getTargetRotation() {
        return this.retrieveOption(OPTION_TARGET_ROTATION);
    }

    @Nullable
    default public Size getTargetResolution(@Nullable Size valueIfMissing) {
        return this.retrieveOption(OPTION_TARGET_RESOLUTION, valueIfMissing);
    }

    @NonNull
    default public Size getTargetResolution() {
        return this.retrieveOption(OPTION_TARGET_RESOLUTION);
    }

    @Nullable
    default public Size getDefaultResolution(@Nullable Size valueIfMissing) {
        return this.retrieveOption(OPTION_DEFAULT_RESOLUTION, valueIfMissing);
    }

    @NonNull
    default public Size getDefaultResolution() {
        return this.retrieveOption(OPTION_DEFAULT_RESOLUTION);
    }

    @Nullable
    default public Size getMaxResolution(@Nullable Size valueIfMissing) {
        return this.retrieveOption(OPTION_MAX_RESOLUTION, valueIfMissing);
    }

    @NonNull
    default public Size getMaxResolution() {
        return this.retrieveOption(OPTION_MAX_RESOLUTION);
    }

    @Nullable
    default public List<Pair<Integer, Size[]>> getSupportedResolutions(@Nullable List<Pair<Integer, Size[]>> valueIfMissing) {
        return this.retrieveOption(OPTION_SUPPORTED_RESOLUTIONS, valueIfMissing);
    }

    @NonNull
    default public List<Pair<Integer, Size[]>> getSupportedResolutions() {
        return this.retrieveOption(OPTION_SUPPORTED_RESOLUTIONS);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RotationValue {
    }

    public static interface Builder<B> {
        @NonNull
        public B setTargetAspectRatioCustom(@NonNull Rational var1);

        @NonNull
        public B setTargetAspectRatio(int var1);

        @NonNull
        public B setTargetRotation(int var1);

        @NonNull
        public B setTargetResolution(@NonNull Size var1);

        @NonNull
        public B setDefaultResolution(@NonNull Size var1);

        @NonNull
        public B setMaxResolution(@NonNull Size var1);

        @NonNull
        public B setSupportedResolutions(@NonNull List<Pair<Integer, Size[]>> var1);
    }
}

