/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl;

import android.os.SystemClock;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.core.impl.Observable;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.concurrent.futures.CallbackToFutureAdapter;
import androidx.core.util.Preconditions;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.Observer;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;

public final class LiveDataObservable<T>
implements Observable<T> {
    final MutableLiveData<Result<T>> mLiveData = new MutableLiveData();
    @GuardedBy(value="mObservers")
    private final Map<Observable.Observer<T>, LiveDataObserverAdapter<T>> mObservers = new HashMap<Observable.Observer<T>, LiveDataObserverAdapter<T>>();

    public void postValue(@Nullable T value) {
        this.mLiveData.postValue(Result.fromValue(value));
    }

    public void postError(@NonNull Throwable error) {
        this.mLiveData.postValue(Result.fromError(error));
    }

    @NonNull
    public LiveData<Result<T>> getLiveData() {
        return this.mLiveData;
    }

    @Override
    @NonNull
    public ListenableFuture<T> fetchData() {
        return CallbackToFutureAdapter.getFuture((CallbackToFutureAdapter.Resolver)new CallbackToFutureAdapter.Resolver<T>(){

            @Nullable
            public Object attachCompleter(final @NonNull CallbackToFutureAdapter.Completer<T> completer) {
                CameraXExecutors.mainThreadExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        Result result = (Result)LiveDataObservable.this.mLiveData.getValue();
                        if (result == null) {
                            completer.setException((Throwable)new IllegalStateException("Observable has not yet been initialized with a value."));
                        } else if (result.completedSuccessfully()) {
                            completer.set(result.getValue());
                        } else {
                            Preconditions.checkNotNull((Object)result.getError());
                            completer.setException(result.getError());
                        }
                    }
                });
                return LiveDataObservable.this + " [fetch@" + SystemClock.uptimeMillis() + "]";
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addObserver(@NonNull Executor executor, @NonNull Observable.Observer<T> observer) {
        Map<Observable.Observer<T>, LiveDataObserverAdapter<T>> map = this.mObservers;
        synchronized (map) {
            final LiveDataObserverAdapter<T> oldAdapter = this.mObservers.get(observer);
            if (oldAdapter != null) {
                oldAdapter.disable();
            }
            final LiveDataObserverAdapter<T> newAdapter = new LiveDataObserverAdapter<T>(executor, observer);
            this.mObservers.put(observer, newAdapter);
            CameraXExecutors.mainThreadExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    LiveDataObservable.this.mLiveData.removeObserver((Observer)oldAdapter);
                    LiveDataObservable.this.mLiveData.observeForever((Observer)newAdapter);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeObserver(@NonNull Observable.Observer<T> observer) {
        Map<Observable.Observer<T>, LiveDataObserverAdapter<T>> map = this.mObservers;
        synchronized (map) {
            final LiveDataObserverAdapter<T> adapter = this.mObservers.remove(observer);
            if (adapter != null) {
                adapter.disable();
                CameraXExecutors.mainThreadExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        LiveDataObservable.this.mLiveData.removeObserver((Observer)adapter);
                    }
                });
            }
        }
    }

    private static final class LiveDataObserverAdapter<T>
    implements Observer<Result<T>> {
        final AtomicBoolean mActive = new AtomicBoolean(true);
        final Observable.Observer<T> mObserver;
        final Executor mExecutor;

        LiveDataObserverAdapter(@NonNull Executor executor, @NonNull Observable.Observer<T> observer) {
            this.mExecutor = executor;
            this.mObserver = observer;
        }

        void disable() {
            this.mActive.set(false);
        }

        public void onChanged(final @NonNull Result<T> result) {
            this.mExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    if (!mActive.get()) {
                        return;
                    }
                    if (result.completedSuccessfully()) {
                        mObserver.onNewData(result.getValue());
                    } else {
                        Preconditions.checkNotNull((Object)result.getError());
                        mObserver.onError(result.getError());
                    }
                }
            });
        }
    }

    public static final class Result<T> {
        @Nullable
        private T mValue;
        @Nullable
        private Throwable mError;

        private Result(@Nullable T value, @Nullable Throwable error) {
            this.mValue = value;
            this.mError = error;
        }

        static <T> Result<T> fromValue(@Nullable T value) {
            return new Result<T>(value, null);
        }

        static <T> Result<T> fromError(@NonNull Throwable error) {
            return new Result<Object>(null, (Throwable)Preconditions.checkNotNull((Object)error));
        }

        public boolean completedSuccessfully() {
            return this.mError == null;
        }

        @Nullable
        public T getValue() {
            if (!this.completedSuccessfully()) {
                throw new IllegalStateException("Result contains an error. Does not contain a value.");
            }
            return this.mValue;
        }

        @Nullable
        public Throwable getError() {
            return this.mError;
        }

        @NonNull
        public String toString() {
            return "[Result: <" + (this.completedSuccessfully() ? "Value: " + this.mValue : "Error: " + this.mError) + ">]";
        }
    }
}

