/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl;

import android.util.Log;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.camera.core.UseCase;
import androidx.camera.core.impl.CameraInternal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public final class UseCaseMediator {
    private static final String TAG = "UseCaseMediator";
    private final Object mListenerLock = new Object();
    private final Object mUseCasesLock = new Object();
    @GuardedBy(value="mUseCasesLock")
    private final Set<UseCase> mUseCases = new HashSet<UseCase>();
    @GuardedBy(value="mListenerLock")
    private StateChangeCallback mStateChangeCallback;
    private volatile boolean mIsActive = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.mListenerLock;
        synchronized (object) {
            if (this.mStateChangeCallback != null) {
                this.mStateChangeCallback.onActive(this);
            }
            this.mIsActive = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.mListenerLock;
        synchronized (object) {
            if (this.mStateChangeCallback != null) {
                this.mStateChangeCallback.onInactive(this);
            }
            this.mIsActive = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setListener(@NonNull StateChangeCallback stateChangeCallback) {
        Object object = this.mListenerLock;
        synchronized (object) {
            this.mStateChangeCallback = stateChangeCallback;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addUseCase(@NonNull UseCase useCase) {
        Object object = this.mUseCasesLock;
        synchronized (object) {
            return this.mUseCases.add(useCase);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(@NonNull UseCase useCase) {
        Object object = this.mUseCasesLock;
        synchronized (object) {
            return this.mUseCases.contains(useCase);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeUseCase(@NonNull UseCase useCase) {
        Object object = this.mUseCasesLock;
        synchronized (object) {
            return this.mUseCases.remove(useCase);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        ArrayList<UseCase> useCasesToClear = new ArrayList<UseCase>();
        Iterator iterator = this.mUseCasesLock;
        synchronized (iterator) {
            useCasesToClear.addAll(this.mUseCases);
            this.mUseCases.clear();
        }
        for (UseCase useCase : useCasesToClear) {
            Log.d((String)TAG, (String)("Destroying use case: " + useCase.getName()));
            useCase.onDetach();
            useCase.onDestroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public Collection<UseCase> getUseCases() {
        Object object = this.mUseCasesLock;
        synchronized (object) {
            return Collections.unmodifiableCollection(this.mUseCases);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public Map<String, Set<UseCase>> getCameraIdToUseCaseMap() {
        HashMap<String, HashSet<UseCase>> cameraIdToUseCases = new HashMap<String, HashSet<UseCase>>();
        Object object = this.mUseCasesLock;
        synchronized (object) {
            for (UseCase useCase : this.mUseCases) {
                CameraInternal attachedCamera = useCase.getCamera();
                if (attachedCamera == null) continue;
                String cameraId = attachedCamera.getCameraInfoInternal().getCameraId();
                HashSet<UseCase> useCaseSet = (HashSet<UseCase>)cameraIdToUseCases.get(cameraId);
                if (useCaseSet == null) {
                    useCaseSet = new HashSet<UseCase>();
                }
                useCaseSet.add(useCase);
                cameraIdToUseCases.put(cameraId, useCaseSet);
            }
        }
        return Collections.unmodifiableMap(cameraIdToUseCases);
    }

    public boolean isActive() {
        return this.mIsActive;
    }

    public static interface StateChangeCallback {
        public void onActive(@NonNull UseCaseMediator var1);

        public void onInactive(@NonNull UseCaseMediator var1);
    }
}

