/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.internal;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.camera.core.ImageCapture;
import androidx.camera.core.UseCase;
import androidx.camera.core.VideoCapture;
import java.util.List;

public final class UseCaseOccupancy {
    private static final String TAG = "UseCaseOccupancy";

    private UseCaseOccupancy() {
    }

    public static boolean checkUseCaseLimitNotExceeded(@NonNull List<UseCase> originalUseCases, @NonNull List<UseCase> newUseCases) {
        int imageCaptureCount = 0;
        int videoCaptureCount = 0;
        for (UseCase useCase : originalUseCases) {
            if (useCase instanceof ImageCapture) {
                ++imageCaptureCount;
                continue;
            }
            if (!(useCase instanceof VideoCapture)) continue;
            ++videoCaptureCount;
        }
        for (UseCase useCase : newUseCases) {
            if (useCase instanceof ImageCapture) {
                ++imageCaptureCount;
                continue;
            }
            if (!(useCase instanceof VideoCapture)) continue;
            ++videoCaptureCount;
        }
        if (imageCaptureCount > 1) {
            Log.e((String)TAG, (String)"Exceeded max simultaneously bound image capture use cases.");
            return false;
        }
        if (videoCaptureCount > 1) {
            Log.e((String)TAG, (String)"Exceeded max simultaneously bound video capture use cases.");
            return false;
        }
        return true;
    }
}

