/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.internal;

import android.annotation.SuppressLint;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.RectF;
import android.util.Rational;
import android.util.Size;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.camera.core.UseCase;
import androidx.camera.core.internal.utils.ImageUtil;
import java.util.HashMap;
import java.util.Map;

public class ViewPorts {
    private ViewPorts() {
    }

    @NonNull
    public static Map<UseCase, Rect> calculateViewPortRects(@NonNull Rect fullSensorRect, @NonNull Rational viewPortAspectRatio, @IntRange(from=0L, to=359L) int outputRotationDegrees, int scaleType, int layoutDirection, @NonNull Map<UseCase, Size> useCaseSizes) {
        Rational rotatedViewPortAspectRatio = ImageUtil.getRotatedAspectRatio(outputRotationDegrees, viewPortAspectRatio);
        RectF fullSensorRectF = new RectF(fullSensorRect);
        HashMap<UseCase, Matrix> useCaseToSensorTransformations = new HashMap<UseCase, Matrix>();
        RectF sensorIntersectionRect = new RectF(fullSensorRect);
        for (Map.Entry<UseCase, Size> entry : useCaseSizes.entrySet()) {
            Matrix useCaseToSensorTransformation = new Matrix();
            RectF srcRect = new RectF(0.0f, 0.0f, (float)entry.getValue().getWidth(), (float)entry.getValue().getHeight());
            useCaseToSensorTransformation.setRectToRect(srcRect, fullSensorRectF, Matrix.ScaleToFit.CENTER);
            useCaseToSensorTransformations.put(entry.getKey(), useCaseToSensorTransformation);
            RectF useCaseSensorRect = new RectF();
            useCaseToSensorTransformation.mapRect(useCaseSensorRect, srcRect);
            sensorIntersectionRect.intersect(useCaseSensorRect);
        }
        sensorIntersectionRect = ViewPorts.getScaledRect(sensorIntersectionRect, rotatedViewPortAspectRatio, scaleType);
        HashMap<UseCase, Rect> useCaseOutputRects = new HashMap<UseCase, Rect>();
        RectF useCaseOutputRect = new RectF();
        Matrix sensorToUseCaseTransformation = new Matrix();
        for (Map.Entry entry : useCaseToSensorTransformations.entrySet()) {
            ((Matrix)entry.getValue()).invert(sensorToUseCaseTransformation);
            sensorToUseCaseTransformation.mapRect(useCaseOutputRect, sensorIntersectionRect);
            ViewPorts.correctOutputRectForRtl(layoutDirection, useCaseSizes.get(entry.getKey()), useCaseOutputRect);
            Rect outputCropRect = new Rect();
            useCaseOutputRect.round(outputCropRect);
            useCaseOutputRects.put((UseCase)entry.getKey(), outputCropRect);
        }
        return useCaseOutputRects;
    }

    static void correctOutputRectForRtl(int layoutDirection, Size size, RectF rect) {
        if (layoutDirection == 0) {
            return;
        }
        Matrix rtlTransformation = new Matrix();
        rtlTransformation.setPolyToPoly(new float[]{0.0f, 0.0f, size.getWidth(), 0.0f, size.getWidth(), size.getHeight(), 0.0f, size.getHeight()}, 0, new float[]{size.getWidth(), 0.0f, 0.0f, 0.0f, 0.0f, size.getHeight(), size.getWidth(), size.getHeight()}, 0, 4);
        rtlTransformation.mapRect(rect);
        float newLeft = Math.min(rect.left, rect.right);
        float newRight = Math.max(rect.left, rect.right);
        float newTop = Math.min(rect.top, rect.bottom);
        float newBottom = Math.max(rect.top, rect.bottom);
        rect.set(newLeft, newTop, newRight, newBottom);
    }

    @SuppressLint(value={"SwitchIntDef"})
    @NonNull
    public static RectF getScaledRect(@NonNull RectF surfaceRect, @NonNull Rational viewPortAspectRatio, int scaleType) {
        Matrix viewPortToSurfaceTransformation = new Matrix();
        RectF viewPortRect = new RectF(0.0f, 0.0f, (float)viewPortAspectRatio.getNumerator(), (float)viewPortAspectRatio.getDenominator());
        if (scaleType == 4 || scaleType == 5 || scaleType == 3) {
            Matrix surfaceToViewPortTransformation = new Matrix();
            switch (scaleType) {
                case 4: {
                    surfaceToViewPortTransformation.setRectToRect(surfaceRect, viewPortRect, Matrix.ScaleToFit.CENTER);
                    break;
                }
                case 3: {
                    surfaceToViewPortTransformation.setRectToRect(surfaceRect, viewPortRect, Matrix.ScaleToFit.START);
                    break;
                }
                case 5: {
                    surfaceToViewPortTransformation.setRectToRect(surfaceRect, viewPortRect, Matrix.ScaleToFit.END);
                }
            }
            surfaceToViewPortTransformation.invert(viewPortToSurfaceTransformation);
        } else if (scaleType == 1 || scaleType == 2 || scaleType == 0) {
            switch (scaleType) {
                case 1: {
                    viewPortToSurfaceTransformation.setRectToRect(viewPortRect, surfaceRect, Matrix.ScaleToFit.CENTER);
                    break;
                }
                case 0: {
                    viewPortToSurfaceTransformation.setRectToRect(viewPortRect, surfaceRect, Matrix.ScaleToFit.START);
                    break;
                }
                case 2: {
                    viewPortToSurfaceTransformation.setRectToRect(viewPortRect, surfaceRect, Matrix.ScaleToFit.END);
                }
            }
        } else {
            throw new IllegalStateException("Unexpected scale type: " + scaleType);
        }
        RectF viewPortRectInSurfaceCoordinates = new RectF();
        viewPortToSurfaceTransformation.mapRect(viewPortRectInSurfaceCoordinates, viewPortRect);
        return viewPortRectInSurfaceCoordinates;
    }
}

