/*
 * Copyright 2019 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.camera.core.impl;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.core.ImageInfo;
import androidx.camera.core.internal.CameraCaptureResultImageInfo;

/**
 * Utility functionality for {@link CameraCaptureResult}.
 */
public final class CameraCaptureResults {
    /**
     * Retrieves the underlying {@link CameraCaptureResult} from the {@link ImageInfo} if the
     * ImageInfo was produced using a CameraCaptureResult.
     *
     * @return The CameraCaptureResult instance or {@code null} if the ImageInfo was constructed
     * without using a CameraCaptureResult.
     */
    @Nullable
    public static CameraCaptureResult retrieveCameraCaptureResult(@NonNull ImageInfo imageInfo) {
        if (imageInfo instanceof CameraCaptureResultImageInfo) {
            return ((CameraCaptureResultImageInfo) imageInfo).getCameraCaptureResult();
        } else {
            return null;
        }
    }

    private CameraCaptureResults() {
    }
}
