/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.experimental.UseExperimental;
import androidx.camera.core.Camera;
import androidx.camera.core.CameraFilter;
import androidx.camera.core.ExperimentalCameraFilter;
import androidx.camera.core.impl.CameraInternal;
import androidx.camera.core.impl.LensFacingCameraFilter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.LinkedHashSet;

public final class CameraSelector {
    public static final int LENS_FACING_FRONT = 0;
    public static final int LENS_FACING_BACK = 1;
    @NonNull
    public static final CameraSelector DEFAULT_FRONT_CAMERA = new Builder().requireLensFacing(0).build();
    @NonNull
    public static final CameraSelector DEFAULT_BACK_CAMERA = new Builder().requireLensFacing(1).build();
    private LinkedHashSet<CameraFilter> mCameraFilterSet;

    CameraSelector(LinkedHashSet<CameraFilter> cameraFilterSet) {
        this.mCameraFilterSet = cameraFilterSet;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @UseExperimental(markerClass=ExperimentalCameraFilter.class)
    @NonNull
    public CameraInternal select(@NonNull LinkedHashSet<CameraInternal> cameras) {
        return (CameraInternal)this.filter(cameras).iterator().next();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @UseExperimental(markerClass=ExperimentalCameraFilter.class)
    @NonNull
    public LinkedHashSet<CameraInternal> filter(@NonNull LinkedHashSet<CameraInternal> cameras) {
        LinkedHashSet<CameraInternal> camerasCopy = new LinkedHashSet<CameraInternal>(cameras);
        LinkedHashSet<Camera> resultCameras = new LinkedHashSet<Camera>(cameras);
        for (CameraFilter filter : this.mCameraFilterSet) {
            resultCameras = filter.filter(resultCameras);
            if (resultCameras.isEmpty()) {
                throw new IllegalArgumentException("No available camera can be found.");
            }
            if (!camerasCopy.containsAll(resultCameras)) {
                throw new IllegalArgumentException("The output isn't contained in the input.");
            }
            camerasCopy.retainAll(resultCameras);
        }
        LinkedHashSet<CameraInternal> returnCameras = new LinkedHashSet<CameraInternal>();
        for (Camera camera : resultCameras) {
            returnCameras.add((CameraInternal)camera);
        }
        return returnCameras;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    public LinkedHashSet<CameraFilter> getCameraFilterSet() {
        return this.mCameraFilterSet;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @UseExperimental(markerClass=ExperimentalCameraFilter.class)
    @Nullable
    public Integer getLensFacing() {
        Integer currentLensFacing = null;
        for (CameraFilter filter : this.mCameraFilterSet) {
            if (!(filter instanceof LensFacingCameraFilter)) continue;
            Integer newLensFacing = ((LensFacingCameraFilter)filter).getLensFacing();
            if (currentLensFacing == null) {
                currentLensFacing = newLensFacing;
                continue;
            }
            if (currentLensFacing.equals(newLensFacing)) continue;
            throw new IllegalStateException("Multiple conflicting lens facing requirements exist.");
        }
        return currentLensFacing;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface LensFacing {
    }

    public static final class Builder {
        private final LinkedHashSet<CameraFilter> mCameraFilterSet;

        public Builder() {
            this.mCameraFilterSet = new LinkedHashSet();
        }

        private Builder(@NonNull LinkedHashSet<CameraFilter> cameraFilterSet) {
            this.mCameraFilterSet = new LinkedHashSet<CameraFilter>(cameraFilterSet);
        }

        @UseExperimental(markerClass=ExperimentalCameraFilter.class)
        @NonNull
        public Builder requireLensFacing(int lensFacing) {
            this.mCameraFilterSet.add(new LensFacingCameraFilter(lensFacing));
            return this;
        }

        @ExperimentalCameraFilter
        @NonNull
        public Builder addCameraFilter(@NonNull CameraFilter cameraFilter) {
            this.mCameraFilterSet.add(cameraFilter);
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public static Builder fromSelector(@NonNull CameraSelector cameraSelector) {
            Builder builder = new Builder(cameraSelector.getCameraFilterSet());
            return builder;
        }

        @NonNull
        public CameraSelector build() {
            return new CameraSelector(this.mCameraFilterSet);
        }
    }
}

