/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import android.view.Surface;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.core.ForwardingImageProxy;
import androidx.camera.core.ImageProxy;
import androidx.camera.core.SingleCloseImageProxy;
import androidx.camera.core.impl.ImageReaderProxy;
import java.util.concurrent.Executor;

class SafeCloseImageReaderProxy
implements ImageReaderProxy {
    private final Object mLock = new Object();
    @GuardedBy(value="mLock")
    private volatile int mOutstandingImages = 0;
    @GuardedBy(value="mLock")
    private volatile boolean mIsClosed = false;
    @GuardedBy(value="mLock")
    private final ImageReaderProxy mImageReaderProxy;
    @Nullable
    private final Surface mSurface;
    private ForwardingImageProxy.OnImageCloseListener mImageCloseListener = image -> {
        Object object = this.mLock;
        synchronized (object) {
            --this.mOutstandingImages;
            if (this.mIsClosed && this.mOutstandingImages == 0) {
                this.close();
            }
        }
    };

    SafeCloseImageReaderProxy(@NonNull ImageReaderProxy imageReaderProxy) {
        this.mImageReaderProxy = imageReaderProxy;
        this.mSurface = imageReaderProxy.getSurface();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public ImageProxy acquireLatestImage() {
        Object object = this.mLock;
        synchronized (object) {
            return this.wrapImageProxy(this.mImageReaderProxy.acquireLatestImage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public ImageProxy acquireNextImage() {
        Object object = this.mLock;
        synchronized (object) {
            return this.wrapImageProxy(this.mImageReaderProxy.acquireNextImage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mSurface != null) {
                this.mSurface.release();
            }
            this.mImageReaderProxy.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value="mLock")
    @Nullable
    private ImageProxy wrapImageProxy(@Nullable ImageProxy imageProxy) {
        Object object = this.mLock;
        synchronized (object) {
            if (imageProxy != null) {
                ++this.mOutstandingImages;
                SingleCloseImageProxy singleCloseImageProxy = new SingleCloseImageProxy(imageProxy);
                singleCloseImageProxy.addOnImageCloseListener(this.mImageCloseListener);
                return singleCloseImageProxy;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value="mLock")
    void safeClose() {
        Object object = this.mLock;
        synchronized (object) {
            this.mIsClosed = true;
            this.mImageReaderProxy.clearOnImageAvailableListener();
            if (this.mOutstandingImages == 0) {
                this.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getHeight() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mImageReaderProxy.getHeight();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getWidth() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mImageReaderProxy.getWidth();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getImageFormat() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mImageReaderProxy.getImageFormat();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaxImages() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mImageReaderProxy.getMaxImages();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Surface getSurface() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mImageReaderProxy.getSurface();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setOnImageAvailableListener(@NonNull ImageReaderProxy.OnImageAvailableListener listener, @NonNull Executor executor) {
        Object object = this.mLock;
        synchronized (object) {
            this.mImageReaderProxy.setOnImageAvailableListener(imageReader -> listener.onImageAvailable(this), executor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearOnImageAvailableListener() {
        Object object = this.mLock;
        synchronized (object) {
            this.mImageReaderProxy.clearOnImageAvailableListener();
        }
    }
}

