/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl;

import androidx.annotation.NonNull;
import androidx.annotation.experimental.UseExperimental;
import androidx.camera.core.Camera;
import androidx.camera.core.CameraFilter;
import androidx.camera.core.ExperimentalCameraFilter;
import androidx.camera.core.impl.CameraInternal;
import androidx.core.util.Preconditions;
import java.util.LinkedHashSet;

@UseExperimental(markerClass=ExperimentalCameraFilter.class)
public class LensFacingCameraFilter
implements CameraFilter {
    private int mLensFacing;

    public LensFacingCameraFilter(int lensFacing) {
        this.mLensFacing = lensFacing;
    }

    @Override
    @NonNull
    public LinkedHashSet<Camera> filter(@NonNull LinkedHashSet<Camera> cameras) {
        LinkedHashSet<Camera> resultCameras = new LinkedHashSet<Camera>();
        for (Camera camera : cameras) {
            Preconditions.checkState((boolean)(camera instanceof CameraInternal), (String)"The camera doesn't contain internal implementation.");
            Integer lensFacing = ((CameraInternal)camera).getCameraInfoInternal().getLensFacing();
            if (lensFacing == null || lensFacing != this.mLensFacing) continue;
            resultCameras.add(camera);
        }
        return resultCameras;
    }

    public int getLensFacing() {
        return this.mLensFacing;
    }
}

