/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.internal;

import android.graphics.Rect;
import android.util.Size;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.experimental.UseExperimental;
import androidx.camera.core.Camera;
import androidx.camera.core.CameraControl;
import androidx.camera.core.CameraFilter;
import androidx.camera.core.CameraInfo;
import androidx.camera.core.CameraSelector;
import androidx.camera.core.ExperimentalCameraFilter;
import androidx.camera.core.ExperimentalUseCaseGroup;
import androidx.camera.core.Logger;
import androidx.camera.core.UseCase;
import androidx.camera.core.ViewPort;
import androidx.camera.core.impl.CameraConfig;
import androidx.camera.core.impl.CameraConfigs;
import androidx.camera.core.impl.CameraDeviceSurfaceManager;
import androidx.camera.core.impl.CameraInfoInternal;
import androidx.camera.core.impl.CameraInternal;
import androidx.camera.core.impl.SurfaceConfig;
import androidx.camera.core.impl.UseCaseConfig;
import androidx.camera.core.impl.UseCaseConfigFactory;
import androidx.camera.core.internal.ViewPorts;
import androidx.core.util.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public final class CameraUseCaseAdapter
implements Camera {
    @NonNull
    private CameraInternal mCameraInternal;
    private final LinkedHashSet<CameraInternal> mCameraInternals;
    private final CameraDeviceSurfaceManager mCameraDeviceSurfaceManager;
    private final UseCaseConfigFactory mUseCaseConfigFactory;
    private static final String TAG = "CameraUseCaseAdapter";
    private final CameraId mId;
    @GuardedBy(value="mLock")
    private final List<UseCase> mUseCases = new ArrayList<UseCase>();
    @GuardedBy(value="mLock")
    @Nullable
    private ViewPort mViewPort;
    @GuardedBy(value="mLock")
    @NonNull
    private CameraConfig mCameraConfig = CameraConfigs.emptyConfig();
    private final Object mLock = new Object();
    @GuardedBy(value="mLock")
    private boolean mAttached = true;

    public CameraUseCaseAdapter(@NonNull LinkedHashSet<CameraInternal> cameras, @NonNull CameraDeviceSurfaceManager cameraDeviceSurfaceManager, @NonNull UseCaseConfigFactory useCaseConfigFactory) {
        this.mCameraInternal = (CameraInternal)cameras.iterator().next();
        this.mCameraInternals = new LinkedHashSet<CameraInternal>(cameras);
        this.mId = new CameraId(this.mCameraInternals);
        this.mCameraDeviceSurfaceManager = cameraDeviceSurfaceManager;
        this.mUseCaseConfigFactory = useCaseConfigFactory;
    }

    @NonNull
    public static CameraId generateCameraId(@NonNull LinkedHashSet<CameraInternal> cameras) {
        return new CameraId(cameras);
    }

    @NonNull
    public CameraId getCameraId() {
        return this.mId;
    }

    public boolean isEquivalent(@NonNull CameraUseCaseAdapter cameraUseCaseAdapter) {
        return this.mId.equals(cameraUseCaseAdapter.getCameraId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setViewPort(@Nullable ViewPort viewPort) {
        Object object = this.mLock;
        synchronized (object) {
            this.mViewPort = viewPort;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkAttachUseCases(@NonNull List<UseCase> useCases) throws CameraException {
        Object object = this.mLock;
        synchronized (object) {
            try {
                Map<UseCase, ConfigPair> configs = this.getConfigs(useCases, this.mCameraConfig.getUseCaseConfigFactory(), this.mUseCaseConfigFactory);
                this.calculateSuggestedResolutions(this.mCameraInternal.getCameraInfoInternal(), useCases, Collections.emptyList(), configs);
            }
            catch (IllegalArgumentException e) {
                throw new CameraException(e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UseExperimental(markerClass=ExperimentalUseCaseGroup.class)
    public void addUseCases(@NonNull Collection<UseCase> useCases) throws CameraException {
        Object object = this.mLock;
        synchronized (object) {
            Map<UseCase, Size> suggestedResolutionsMap;
            ArrayList<UseCase> newUseCases = new ArrayList<UseCase>();
            for (UseCase useCase : useCases) {
                if (this.mUseCases.contains(useCase)) {
                    Logger.d(TAG, "Attempting to attach already attached UseCase");
                    continue;
                }
                newUseCases.add(useCase);
            }
            Map<UseCase, ConfigPair> configs = this.getConfigs(newUseCases, this.mCameraConfig.getUseCaseConfigFactory(), this.mUseCaseConfigFactory);
            try {
                suggestedResolutionsMap = this.calculateSuggestedResolutions(this.mCameraInternal.getCameraInfoInternal(), newUseCases, this.mUseCases, configs);
            }
            catch (IllegalArgumentException e) {
                throw new CameraException(e.getMessage());
            }
            this.updateViewPort(suggestedResolutionsMap, useCases);
            for (UseCase useCase : newUseCases) {
                ConfigPair configPair = configs.get(useCase);
                useCase.onAttach(this.mCameraInternal, configPair.mExtendedConfig, configPair.mCameraConfig);
                useCase.updateSuggestedResolution((Size)Preconditions.checkNotNull((Object)suggestedResolutionsMap.get(useCase)));
            }
            this.mUseCases.addAll(newUseCases);
            if (this.mAttached) {
                this.mCameraInternal.attachUseCases(newUseCases);
            }
            for (UseCase useCase : newUseCases) {
                useCase.notifyState();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUseCases(@NonNull Collection<UseCase> useCases) {
        Object object = this.mLock;
        synchronized (object) {
            this.mCameraInternal.detachUseCases(useCases);
            for (UseCase useCase : useCases) {
                if (this.mUseCases.contains(useCase)) {
                    useCase.onDetach(this.mCameraInternal);
                    continue;
                }
                Logger.e(TAG, "Attempting to detach non-attached UseCase: " + useCase);
            }
            this.mUseCases.removeAll(useCases);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public List<UseCase> getUseCases() {
        Object object = this.mLock;
        synchronized (object) {
            return new ArrayList<UseCase>(this.mUseCases);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attachUseCases() {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mAttached) {
                this.mCameraInternal.attachUseCases(this.mUseCases);
                for (UseCase useCase : this.mUseCases) {
                    useCase.notifyState();
                }
                this.mAttached = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detachUseCases() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mAttached) {
                this.mCameraInternal.detachUseCases(new ArrayList<UseCase>(this.mUseCases));
                this.mAttached = false;
            }
        }
    }

    private Map<UseCase, Size> calculateSuggestedResolutions(@NonNull CameraInfoInternal cameraInfoInternal, @NonNull List<UseCase> newUseCases, @NonNull List<UseCase> currentUseCases, @NonNull Map<UseCase, ConfigPair> configPairMap) {
        ArrayList<SurfaceConfig> existingSurfaces = new ArrayList<SurfaceConfig>();
        String cameraId = cameraInfoInternal.getCameraId();
        HashMap<UseCase, Size> suggestedResolutions = new HashMap<UseCase, Size>();
        for (UseCase useCase : currentUseCases) {
            SurfaceConfig surfaceConfig = this.mCameraDeviceSurfaceManager.transformSurfaceConfig(cameraId, useCase.getImageFormat(), useCase.getAttachedSurfaceResolution());
            existingSurfaces.add(surfaceConfig);
            suggestedResolutions.put(useCase, useCase.getAttachedSurfaceResolution());
        }
        if (!newUseCases.isEmpty()) {
            HashMap configToUseCaseMap = new HashMap();
            for (UseCase useCase : newUseCases) {
                ConfigPair configPair = configPairMap.get(useCase);
                UseCaseConfig<?> combinedUseCaseConfig = useCase.mergeConfigs(configPair.mExtendedConfig, configPair.mCameraConfig);
                configToUseCaseMap.put(combinedUseCaseConfig, useCase);
            }
            Map<UseCaseConfig<?>, Size> map = this.mCameraDeviceSurfaceManager.getSuggestedResolutions(cameraId, existingSurfaces, new ArrayList(configToUseCaseMap.keySet()));
            for (Map.Entry entry : configToUseCaseMap.entrySet()) {
                suggestedResolutions.put((UseCase)entry.getValue(), map.get(entry.getKey()));
            }
        }
        return suggestedResolutions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UseExperimental(markerClass=ExperimentalUseCaseGroup.class)
    private void updateViewPort(@NonNull Map<UseCase, Size> suggestedResolutionsMap, @NonNull Collection<UseCase> useCases) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mViewPort != null) {
                boolean isFrontCamera = this.mCameraInternal.getCameraInfoInternal().getLensFacing() == 0;
                Map<UseCase, Rect> cropRectMap = ViewPorts.calculateViewPortRects(this.mCameraInternal.getCameraControlInternal().getSensorRect(), isFrontCamera, this.mViewPort.getAspectRatio(), this.mCameraInternal.getCameraInfoInternal().getSensorRotationDegrees(this.mViewPort.getRotation()), this.mViewPort.getScaleType(), this.mViewPort.getLayoutDirection(), suggestedResolutionsMap);
                for (UseCase useCase : useCases) {
                    useCase.setViewPortCropRect((Rect)Preconditions.checkNotNull((Object)cropRectMap.get(useCase)));
                }
            }
        }
    }

    private Map<UseCase, ConfigPair> getConfigs(List<UseCase> useCases, UseCaseConfigFactory extendedFactory, UseCaseConfigFactory cameraFactory) {
        HashMap<UseCase, ConfigPair> configs = new HashMap<UseCase, ConfigPair>();
        for (UseCase useCase : useCases) {
            configs.put(useCase, new ConfigPair(useCase.getDefaultConfig(false, extendedFactory), useCase.getDefaultConfig(true, cameraFactory)));
        }
        return configs;
    }

    @Override
    @NonNull
    public CameraControl getCameraControl() {
        return this.mCameraInternal.getCameraControlInternal();
    }

    @Override
    @NonNull
    public CameraInfo getCameraInfo() {
        return this.mCameraInternal.getCameraInfoInternal();
    }

    @Override
    @NonNull
    public LinkedHashSet<CameraInternal> getCameraInternals() {
        return this.mCameraInternals;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public CameraConfig getExtendedConfig() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mCameraConfig;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @UseExperimental(markerClass=ExperimentalCameraFilter.class)
    public void setExtendedConfig(@Nullable CameraConfig cameraConfig) throws CameraException {
        Object object = this.mLock;
        synchronized (object) {
            Map<UseCase, Size> suggestedResolutionsMap;
            CameraConfig newCameraConfig = cameraConfig == null ? CameraConfigs.emptyConfig() : cameraConfig;
            CameraFilter cameraFilter = newCameraConfig.getCameraFilter();
            CameraSelector cameraSelector = new CameraSelector.Builder().addCameraFilter(cameraFilter).build();
            CameraInternal cameraInternal = cameraSelector.select(this.mCameraInternals);
            Map<UseCase, ConfigPair> configs = this.getConfigs(this.mUseCases, newCameraConfig.getUseCaseConfigFactory(), this.mUseCaseConfigFactory);
            try {
                suggestedResolutionsMap = this.calculateSuggestedResolutions(cameraInternal.getCameraInfoInternal(), this.mUseCases, Collections.emptyList(), configs);
            }
            catch (IllegalArgumentException e) {
                throw new CameraException(e.getMessage());
            }
            this.updateViewPort(suggestedResolutionsMap, this.mUseCases);
            if (this.mAttached) {
                this.mCameraInternal.detachUseCases(this.mUseCases);
            }
            for (UseCase useCase : this.mUseCases) {
                useCase.onDetach(this.mCameraInternal);
            }
            for (UseCase useCase : this.mUseCases) {
                ConfigPair configPair = configs.get(useCase);
                useCase.onAttach(cameraInternal, configPair.mExtendedConfig, configPair.mCameraConfig);
                useCase.updateSuggestedResolution((Size)Preconditions.checkNotNull((Object)suggestedResolutionsMap.get(useCase)));
            }
            if (this.mAttached) {
                cameraInternal.attachUseCases(this.mUseCases);
            }
            for (UseCase useCase : this.mUseCases) {
                useCase.notifyState();
            }
            this.mCameraInternal = cameraInternal;
            this.mCameraConfig = newCameraConfig;
        }
    }

    public static final class CameraException
    extends Exception {
        public CameraException() {
        }

        public CameraException(@NonNull String message) {
            super(message);
        }

        public CameraException(@NonNull Throwable cause) {
            super(cause);
        }
    }

    public static final class CameraId {
        private final List<String> mIds = new ArrayList<String>();

        CameraId(LinkedHashSet<CameraInternal> cameraInternals) {
            for (CameraInternal cameraInternal : cameraInternals) {
                this.mIds.add(cameraInternal.getCameraInfoInternal().getCameraId());
            }
        }

        public boolean equals(Object cameraId) {
            if (cameraId instanceof CameraId) {
                return this.mIds.equals(((CameraId)cameraId).mIds);
            }
            return false;
        }

        public int hashCode() {
            return 53 * this.mIds.hashCode();
        }
    }

    private static class ConfigPair {
        UseCaseConfig<?> mExtendedConfig;
        UseCaseConfig<?> mCameraConfig;

        ConfigPair(UseCaseConfig<?> extendedConfig, UseCaseConfig<?> cameraConfig) {
            this.mExtendedConfig = extendedConfig;
            this.mCameraConfig = cameraConfig;
        }
    }
}

