/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import androidx.annotation.GuardedBy;
import androidx.annotation.Nullable;
import androidx.camera.core.ImageAnalysis;
import androidx.camera.core.ImageInfo;
import androidx.camera.core.ImageProxy;
import androidx.camera.core.ImmutableImageInfo;
import androidx.camera.core.SettableImageProxy;
import androidx.camera.core.impl.ImageReaderProxy;
import androidx.camera.core.impl.utils.futures.Futures;
import androidx.concurrent.futures.CallbackToFutureAdapter;
import androidx.core.os.OperationCanceledException;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;

abstract class ImageAnalysisAbstractAnalyzer
implements ImageReaderProxy.OnImageAvailableListener {
    @GuardedBy(value="mAnalyzerLock")
    private ImageAnalysis.Analyzer mSubscribedAnalyzer;
    private volatile int mRelativeRotation;
    @GuardedBy(value="mAnalyzerLock")
    private Executor mUserExecutor;
    private final Object mAnalyzerLock = new Object();
    private AtomicBoolean mIsClosed = new AtomicBoolean(false);

    ImageAnalysisAbstractAnalyzer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ListenableFuture<Void> analyzeImage(ImageProxy imageProxy) {
        ImageAnalysis.Analyzer analyzer;
        Executor executor;
        Object object = this.mAnalyzerLock;
        synchronized (object) {
            executor = this.mUserExecutor;
            analyzer = this.mSubscribedAnalyzer;
        }
        ListenableFuture future = analyzer != null && executor != null ? CallbackToFutureAdapter.getFuture(completer -> {
            executor.execute(() -> {
                if (!this.isClosed()) {
                    ImageInfo imageInfo = ImmutableImageInfo.create(imageProxy.getImageInfo().getTagBundle(), imageProxy.getImageInfo().getTimestamp(), this.mRelativeRotation);
                    analyzer.analyze(new SettableImageProxy(imageProxy, imageInfo));
                    completer.set(null);
                } else {
                    completer.setException((Throwable)new OperationCanceledException("Closed before analysis"));
                }
            });
            return "analyzeImage";
        }) : Futures.immediateFailedFuture((Throwable)new OperationCanceledException("No analyzer or executor currently set."));
        return future;
    }

    void setRelativeRotation(int relativeRotation) {
        this.mRelativeRotation = relativeRotation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setAnalyzer(@Nullable Executor userExecutor, @Nullable ImageAnalysis.Analyzer subscribedAnalyzer) {
        Object object = this.mAnalyzerLock;
        synchronized (object) {
            this.mSubscribedAnalyzer = subscribedAnalyzer;
            this.mUserExecutor = userExecutor;
        }
    }

    void open() {
        this.mIsClosed.set(false);
    }

    void close() {
        this.mIsClosed.set(true);
    }

    boolean isClosed() {
        return this.mIsClosed.get();
    }
}

