/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.RectF;
import android.location.Location;
import android.net.Uri;
import android.os.Build;
import android.os.Looper;
import android.os.SystemClock;
import android.util.Log;
import android.util.Pair;
import android.util.Rational;
import android.util.Size;
import androidx.annotation.GuardedBy;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.UiThread;
import androidx.annotation.VisibleForTesting;
import androidx.camera.core.CameraClosedException;
import androidx.camera.core.CameraSelector;
import androidx.camera.core.CaptureBundles;
import androidx.camera.core.ForwardingImageProxy;
import androidx.camera.core.ImageCaptureException;
import androidx.camera.core.ImageInfo;
import androidx.camera.core.ImageProxy;
import androidx.camera.core.ImageReaderProxyProvider;
import androidx.camera.core.ImageSaveLocationValidator;
import androidx.camera.core.ImageSaver;
import androidx.camera.core.ImmutableImageInfo;
import androidx.camera.core.Logger;
import androidx.camera.core.MetadataImageReader;
import androidx.camera.core.ProcessingImageReader;
import androidx.camera.core.SafeCloseImageReaderProxy;
import androidx.camera.core.SettableImageProxy;
import androidx.camera.core.SingleCloseImageProxy;
import androidx.camera.core.UseCase;
import androidx.camera.core.impl.CameraCaptureCallback;
import androidx.camera.core.impl.CameraCaptureFailure;
import androidx.camera.core.impl.CameraCaptureMetaData;
import androidx.camera.core.impl.CameraCaptureResult;
import androidx.camera.core.impl.CameraInfoInternal;
import androidx.camera.core.impl.CameraInternal;
import androidx.camera.core.impl.CaptureBundle;
import androidx.camera.core.impl.CaptureConfig;
import androidx.camera.core.impl.CaptureProcessor;
import androidx.camera.core.impl.CaptureStage;
import androidx.camera.core.impl.Config;
import androidx.camera.core.impl.ConfigProvider;
import androidx.camera.core.impl.DeferrableSurface;
import androidx.camera.core.impl.ImageCaptureConfig;
import androidx.camera.core.impl.ImageInputConfig;
import androidx.camera.core.impl.ImageOutputConfig;
import androidx.camera.core.impl.ImageReaderProxy;
import androidx.camera.core.impl.ImmediateSurface;
import androidx.camera.core.impl.MutableConfig;
import androidx.camera.core.impl.MutableOptionsBundle;
import androidx.camera.core.impl.OptionsBundle;
import androidx.camera.core.impl.SessionConfig;
import androidx.camera.core.impl.UseCaseConfig;
import androidx.camera.core.impl.UseCaseConfigFactory;
import androidx.camera.core.impl.utils.CameraOrientationUtil;
import androidx.camera.core.impl.utils.Exif;
import androidx.camera.core.impl.utils.Threads;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.camera.core.impl.utils.futures.FutureCallback;
import androidx.camera.core.impl.utils.futures.FutureChain;
import androidx.camera.core.impl.utils.futures.Futures;
import androidx.camera.core.internal.IoConfig;
import androidx.camera.core.internal.TargetConfig;
import androidx.camera.core.internal.YuvToJpegProcessor;
import androidx.camera.core.internal.compat.quirk.SoftwareJpegEncodingPreferredQuirk;
import androidx.camera.core.internal.compat.workaround.ExifRotationAvailability;
import androidx.camera.core.internal.utils.ImageUtil;
import androidx.concurrent.futures.CallbackToFutureAdapter;
import androidx.core.util.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class ImageCapture
extends UseCase {
    public static final int ERROR_UNKNOWN = 0;
    public static final int ERROR_FILE_IO = 1;
    public static final int ERROR_CAPTURE_FAILED = 2;
    public static final int ERROR_CAMERA_CLOSED = 3;
    public static final int ERROR_INVALID_CAMERA = 4;
    public static final int CAPTURE_MODE_MAXIMIZE_QUALITY = 0;
    public static final int CAPTURE_MODE_MINIMIZE_LATENCY = 1;
    private static final int FLASH_MODE_UNKNOWN = -1;
    public static final int FLASH_MODE_AUTO = 0;
    public static final int FLASH_MODE_ON = 1;
    public static final int FLASH_MODE_OFF = 2;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final Defaults DEFAULT_CONFIG = new Defaults();
    private static final String TAG = "ImageCapture";
    private static final long CHECK_3A_TIMEOUT_IN_MS = 1000L;
    private static final int MAX_IMAGES = 2;
    private static final byte JPEG_QUALITY_MAXIMIZE_QUALITY_MODE = 100;
    private static final byte JPEG_QUALITY_MINIMIZE_LATENCY_MODE = 95;
    private static final int DEFAULT_CAPTURE_MODE = 1;
    private static final int DEFAULT_FLASH_MODE = 2;
    private final CaptureCallbackChecker mSessionCallbackChecker = new CaptureCallbackChecker();
    private final ImageReaderProxy.OnImageAvailableListener mClosingListener = imageReader -> {
        try (ImageProxy image = imageReader.acquireLatestImage();){
            Log.d((String)TAG, (String)("Discarding ImageProxy which was inadvertently acquired: " + image));
        }
        catch (IllegalStateException e) {
            Log.e((String)TAG, (String)"Failed to acquire latest image.", (Throwable)e);
        }
    };
    @NonNull
    final Executor mIoExecutor;
    private final int mCaptureMode;
    private final boolean mEnableCheck3AConverged;
    @GuardedBy(value="mLockedFlashMode")
    private final AtomicReference<Integer> mLockedFlashMode = new AtomicReference<Object>(null);
    @GuardedBy(value="mLockedFlashMode")
    private int mFlashMode = -1;
    private Rational mCropAspectRatio = null;
    private ExecutorService mExecutor;
    private CaptureConfig mCaptureConfig;
    private CaptureBundle mCaptureBundle;
    private int mMaxCaptureStages;
    private CaptureProcessor mCaptureProcessor;
    private boolean mUseSoftwareJpeg = false;
    SessionConfig.Builder mSessionConfigBuilder;
    SafeCloseImageReaderProxy mImageReader;
    ProcessingImageReader mProcessingImageReader;
    private CameraCaptureCallback mMetadataMatchingCaptureCallback;
    private DeferrableSurface mDeferrableSurface;
    private ImageCaptureRequestProcessor mImageCaptureRequestProcessor;
    final Executor mSequentialIoExecutor;

    ImageCapture(@NonNull ImageCaptureConfig userConfig) {
        super(userConfig);
        ImageCaptureConfig useCaseConfig = (ImageCaptureConfig)this.getCurrentConfig();
        this.mCaptureMode = useCaseConfig.containsOption(ImageCaptureConfig.OPTION_IMAGE_CAPTURE_MODE) ? useCaseConfig.getCaptureMode() : 1;
        this.mIoExecutor = (Executor)Preconditions.checkNotNull((Object)useCaseConfig.getIoExecutor(CameraXExecutors.ioExecutor()));
        this.mSequentialIoExecutor = CameraXExecutors.newSequentialExecutor(this.mIoExecutor);
        this.mEnableCheck3AConverged = this.mCaptureMode == 0;
    }

    @UiThread
    SessionConfig.Builder createPipeline(@NonNull String cameraId, @NonNull ImageCaptureConfig config, @NonNull Size resolution) {
        Threads.checkMainThread();
        SessionConfig.Builder sessionConfigBuilder = SessionConfig.Builder.createFrom(config);
        sessionConfigBuilder.addRepeatingCameraCaptureCallback(this.mSessionCallbackChecker);
        if (config.getImageReaderProxyProvider() != null) {
            this.mImageReader = new SafeCloseImageReaderProxy(config.getImageReaderProxyProvider().newInstance(resolution.getWidth(), resolution.getHeight(), this.getImageFormat(), 2, 0L));
            this.mMetadataMatchingCaptureCallback = new CameraCaptureCallback(){};
        } else if (this.mCaptureProcessor != null || this.mUseSoftwareJpeg) {
            YuvToJpegProcessor softwareJpegProcessor = null;
            CaptureProcessor captureProcessor = this.mCaptureProcessor;
            int inputFormat = this.getImageFormat();
            int outputFormat = this.getImageFormat();
            if (this.mUseSoftwareJpeg) {
                Preconditions.checkState((this.mCaptureProcessor == null ? 1 : 0) != 0, (String)"CaptureProcessor should not be set if software JPEG is to be used.");
                if (Build.VERSION.SDK_INT >= 26) {
                    Logger.i(TAG, "Using software JPEG encoder.");
                    softwareJpegProcessor = new YuvToJpegProcessor(this.getJpegQuality(), this.mMaxCaptureStages);
                    captureProcessor = softwareJpegProcessor;
                    outputFormat = 256;
                } else {
                    throw new IllegalStateException("Software JPEG only supported on API 26+");
                }
            }
            this.mProcessingImageReader = new ProcessingImageReader(resolution.getWidth(), resolution.getHeight(), inputFormat, this.mMaxCaptureStages, this.mExecutor, this.getCaptureBundle(CaptureBundles.singleDefaultCaptureBundle()), captureProcessor, outputFormat);
            this.mMetadataMatchingCaptureCallback = this.mProcessingImageReader.getCameraCaptureCallback();
            this.mImageReader = new SafeCloseImageReaderProxy(this.mProcessingImageReader);
            if (softwareJpegProcessor != null) {
                YuvToJpegProcessor processorToClose = softwareJpegProcessor;
                this.mProcessingImageReader.getCloseFuture().addListener(() -> {
                    if (Build.VERSION.SDK_INT >= 26) {
                        processorToClose.close();
                    }
                }, CameraXExecutors.directExecutor());
            }
        } else {
            MetadataImageReader metadataImageReader = new MetadataImageReader(resolution.getWidth(), resolution.getHeight(), this.getImageFormat(), 2);
            this.mMetadataMatchingCaptureCallback = metadataImageReader.getCameraCaptureCallback();
            this.mImageReader = new SafeCloseImageReaderProxy(metadataImageReader);
        }
        this.mImageCaptureRequestProcessor = new ImageCaptureRequestProcessor(2, request -> this.takePictureInternal(request));
        this.mImageReader.setOnImageAvailableListener(this.mClosingListener, CameraXExecutors.mainThreadExecutor());
        SafeCloseImageReaderProxy imageReaderProxy = this.mImageReader;
        if (this.mDeferrableSurface != null) {
            this.mDeferrableSurface.close();
        }
        this.mDeferrableSurface = new ImmediateSurface(this.mImageReader.getSurface());
        this.mDeferrableSurface.getTerminationFuture().addListener(imageReaderProxy::safeClose, (Executor)CameraXExecutors.mainThreadExecutor());
        sessionConfigBuilder.addNonRepeatingSurface(this.mDeferrableSurface);
        sessionConfigBuilder.addErrorListener((sessionConfig, error) -> {
            this.clearPipeline();
            if (this.isCurrentCamera(cameraId)) {
                this.mSessionConfigBuilder = this.createPipeline(cameraId, config, resolution);
                this.updateSessionConfig(this.mSessionConfigBuilder.build());
                this.notifyReset();
            }
        });
        return sessionConfigBuilder;
    }

    @UiThread
    void clearPipeline() {
        Threads.checkMainThread();
        DeferrableSurface deferrableSurface = this.mDeferrableSurface;
        this.mDeferrableSurface = null;
        this.mImageReader = null;
        this.mProcessingImageReader = null;
        if (deferrableSurface != null) {
            deferrableSurface.close();
        }
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public UseCaseConfig<?> getDefaultConfig(boolean applyDefaultConfig, @NonNull UseCaseConfigFactory factory) {
        Config captureConfig = factory.getConfig(UseCaseConfigFactory.CaptureType.IMAGE_CAPTURE);
        if (applyDefaultConfig) {
            captureConfig = Config.mergeConfigs(captureConfig, DEFAULT_CONFIG.getConfig());
        }
        return captureConfig == null ? null : (UseCaseConfig<?>)this.getUseCaseConfigBuilder(captureConfig).getUseCaseConfig();
    }

    @Override
    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public UseCaseConfig.Builder<?, ?, ?> getUseCaseConfigBuilder(@NonNull Config config) {
        return Builder.fromConfig(config);
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    UseCaseConfig<?> onMergeConfig(@NonNull CameraInfoInternal cameraInfo, @NonNull UseCaseConfig.Builder<?, ?, ?> builder) {
        if (cameraInfo.getCameraQuirks().contains(SoftwareJpegEncodingPreferredQuirk.class)) {
            if (!builder.getMutableConfig().retrieveOption(ImageCaptureConfig.OPTION_USE_SOFTWARE_JPEG_ENCODER, true).booleanValue()) {
                Logger.w(TAG, "Device quirk suggests software JPEG encoder, but it has been explicitly disabled.");
            } else {
                Logger.i(TAG, "Requesting software JPEG due to device quirk.");
                builder.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_USE_SOFTWARE_JPEG_ENCODER, true);
            }
        }
        boolean useSoftwareJpeg = ImageCapture.enforceSoftwareJpegConstraints(builder.getMutableConfig());
        Integer bufferFormat = builder.getMutableConfig().retrieveOption(ImageCaptureConfig.OPTION_BUFFER_FORMAT, null);
        if (bufferFormat != null) {
            Preconditions.checkArgument((builder.getMutableConfig().retrieveOption(ImageCaptureConfig.OPTION_CAPTURE_PROCESSOR, null) == null ? 1 : 0) != 0, (Object)"Cannot set buffer format with CaptureProcessor defined.");
            builder.getMutableConfig().insertOption(ImageInputConfig.OPTION_INPUT_FORMAT, useSoftwareJpeg ? 35 : bufferFormat);
        } else if (builder.getMutableConfig().retrieveOption(ImageCaptureConfig.OPTION_CAPTURE_PROCESSOR, null) != null || useSoftwareJpeg) {
            builder.getMutableConfig().insertOption(ImageInputConfig.OPTION_INPUT_FORMAT, 35);
        } else {
            builder.getMutableConfig().insertOption(ImageInputConfig.OPTION_INPUT_FORMAT, 256);
        }
        Preconditions.checkArgument((builder.getMutableConfig().retrieveOption(ImageCaptureConfig.OPTION_MAX_CAPTURE_STAGES, 2) >= 1 ? 1 : 0) != 0, (Object)"Maximum outstanding image count must be at least 1");
        return builder.getUseCaseConfig();
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected void onCameraControlReady() {
        this.trySetFlashModeToCameraControl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFlashMode() {
        AtomicReference<Integer> atomicReference = this.mLockedFlashMode;
        synchronized (atomicReference) {
            return this.mFlashMode != -1 ? this.mFlashMode : ((ImageCaptureConfig)this.getCurrentConfig()).getFlashMode(2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFlashMode(int flashMode) {
        if (flashMode != 0 && flashMode != 1 && flashMode != 2) {
            throw new IllegalArgumentException("Invalid flash mode: " + flashMode);
        }
        AtomicReference<Integer> atomicReference = this.mLockedFlashMode;
        synchronized (atomicReference) {
            this.mFlashMode = flashMode;
            this.trySetFlashModeToCameraControl();
        }
    }

    public void setCropAspectRatio(@NonNull Rational aspectRatio) {
        this.mCropAspectRatio = aspectRatio;
    }

    public int getTargetRotation() {
        return this.getTargetRotationInternal();
    }

    public void setTargetRotation(int rotation) {
        int oldRotation = this.getTargetRotation();
        if (this.setTargetRotationInternal(rotation) && this.mCropAspectRatio != null) {
            int oldRotationDegrees = CameraOrientationUtil.surfaceRotationToDegrees(oldRotation);
            int newRotationDegrees = CameraOrientationUtil.surfaceRotationToDegrees(rotation);
            this.mCropAspectRatio = ImageUtil.getRotatedAspectRatio(Math.abs(newRotationDegrees - oldRotationDegrees), this.mCropAspectRatio);
        }
    }

    public int getCaptureMode() {
        return this.mCaptureMode;
    }

    public void takePicture(@NonNull Executor executor, @NonNull OnImageCapturedCallback callback) {
        if (Looper.getMainLooper() != Looper.myLooper()) {
            CameraXExecutors.mainThreadExecutor().execute(() -> this.takePicture(executor, callback));
            return;
        }
        this.sendImageCaptureRequest(executor, callback);
    }

    public void takePicture(@NonNull OutputFileOptions outputFileOptions, @NonNull Executor executor, @NonNull OnImageSavedCallback imageSavedCallback) {
        this.mSequentialIoExecutor.execute(() -> {
            if (!ImageSaveLocationValidator.isValid(outputFileOptions)) {
                executor.execute(() -> imageSavedCallback.onError(new ImageCaptureException(1, "Cannot save capture result to specified location", null)));
            } else {
                CameraXExecutors.mainThreadExecutor().execute(() -> this.takePictureAfterValidation(outputFileOptions, executor, imageSavedCallback));
            }
        });
    }

    @UiThread
    private void takePictureAfterValidation(final @NonNull OutputFileOptions outputFileOptions, final @NonNull Executor executor, final @NonNull OnImageSavedCallback imageSavedCallback) {
        Threads.checkMainThread();
        final ImageSaver.OnImageSavedCallback imageSavedCallbackWrapper = new ImageSaver.OnImageSavedCallback(){

            @Override
            public void onImageSaved(@NonNull OutputFileResults outputFileResults) {
                imageSavedCallback.onImageSaved(outputFileResults);
            }

            @Override
            public void onError(@NonNull ImageSaver.SaveError error, @NonNull String message, @Nullable Throwable cause) {
                int imageCaptureError = 0;
                switch (error) {
                    case FILE_IO_FAILED: {
                        imageCaptureError = 1;
                        break;
                    }
                }
                imageSavedCallback.onError(new ImageCaptureException(imageCaptureError, message, cause));
            }
        };
        OnImageCapturedCallback imageCaptureCallbackWrapper = new OnImageCapturedCallback(){

            @Override
            public void onCaptureSuccess(@NonNull ImageProxy image) {
                ImageCapture.this.mIoExecutor.execute(new ImageSaver(image, outputFileOptions, image.getImageInfo().getRotationDegrees(), executor, ImageCapture.this.mSequentialIoExecutor, imageSavedCallbackWrapper));
            }

            @Override
            public void onError(@NonNull ImageCaptureException exception) {
                imageSavedCallback.onError(exception);
            }
        };
        this.sendImageCaptureRequest(CameraXExecutors.mainThreadExecutor(), imageCaptureCallbackWrapper);
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @UiThread
    public void onStateDetached() {
        this.abortImageCaptureRequests();
    }

    private void abortImageCaptureRequests() {
        CameraClosedException throwable = new CameraClosedException("Camera is closed.");
        this.mImageCaptureRequestProcessor.cancelRequests(throwable);
    }

    @UiThread
    private void sendImageCaptureRequest(@NonNull Executor callbackExecutor, @NonNull OnImageCapturedCallback callback) {
        CameraInternal attachedCamera = this.getCamera();
        if (attachedCamera == null) {
            callbackExecutor.execute(() -> callback.onError(new ImageCaptureException(4, "Not bound to a valid Camera [" + this + "]", null)));
            return;
        }
        this.mImageCaptureRequestProcessor.sendRequest(new ImageCaptureRequest(this.getRelativeRotation(attachedCamera), this.getJpegQuality(), this.mCropAspectRatio, this.getViewPortCropRect(), callbackExecutor, callback));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lockFlashMode() {
        AtomicReference<Integer> atomicReference = this.mLockedFlashMode;
        synchronized (atomicReference) {
            if (this.mLockedFlashMode.get() != null) {
                return;
            }
            this.mLockedFlashMode.set(this.getFlashMode());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unlockFlashMode() {
        AtomicReference<Integer> atomicReference = this.mLockedFlashMode;
        synchronized (atomicReference) {
            Integer lockedFlashMode = this.mLockedFlashMode.getAndSet(null);
            if (lockedFlashMode == null) {
                return;
            }
            if (lockedFlashMode.intValue() != this.getFlashMode()) {
                this.trySetFlashModeToCameraControl();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trySetFlashModeToCameraControl() {
        AtomicReference<Integer> atomicReference = this.mLockedFlashMode;
        synchronized (atomicReference) {
            if (this.mLockedFlashMode.get() != null) {
                return;
            }
            this.getCameraControl().setFlashMode(this.getFlashMode());
        }
    }

    @IntRange(from=1L, to=100L)
    private int getJpegQuality() {
        switch (this.mCaptureMode) {
            case 0: {
                return 100;
            }
            case 1: {
                return 95;
            }
        }
        throw new IllegalStateException("CaptureMode " + this.mCaptureMode + " is invalid");
    }

    private ListenableFuture<ImageProxy> takePictureInternal(@NonNull ImageCaptureRequest imageCaptureRequest) {
        return CallbackToFutureAdapter.getFuture(completer -> {
            this.mImageReader.setOnImageAvailableListener(imageReader -> {
                try {
                    ImageProxy image = imageReader.acquireLatestImage();
                    if (image != null) {
                        if (!completer.set((Object)image)) {
                            image.close();
                        }
                    } else {
                        completer.setException((Throwable)new IllegalStateException("Unable to acquire image"));
                    }
                }
                catch (IllegalStateException e) {
                    completer.setException((Throwable)e);
                }
            }, CameraXExecutors.mainThreadExecutor());
            final TakePictureState state = new TakePictureState();
            FutureChain future = FutureChain.from(this.preTakePicture(state)).transformAsync(v -> this.issueTakePicture(imageCaptureRequest), this.mExecutor);
            Futures.addCallback(future, new FutureCallback<Void>(){

                @Override
                public void onSuccess(Void result) {
                    ImageCapture.this.postTakePicture(state);
                }

                @Override
                public void onFailure(Throwable throwable) {
                    ImageCapture.this.postTakePicture(state);
                    completer.setException(throwable);
                }
            }, this.mExecutor);
            completer.addCancellationListener(() -> future.cancel(true), CameraXExecutors.directExecutor());
            return "takePictureInternal";
        });
    }

    @NonNull
    public String toString() {
        return "ImageCapture:" + this.getName();
    }

    static int getError(Throwable throwable) {
        if (throwable instanceof CameraClosedException) {
            return 3;
        }
        if (throwable instanceof CaptureFailedException) {
            return 2;
        }
        return 0;
    }

    static boolean enforceSoftwareJpegConstraints(@NonNull MutableConfig mutableConfig) {
        if (mutableConfig.retrieveOption(ImageCaptureConfig.OPTION_USE_SOFTWARE_JPEG_ENCODER, false).booleanValue()) {
            Integer bufferFormat;
            boolean supported = true;
            if (Build.VERSION.SDK_INT < 26) {
                Logger.w(TAG, "Software JPEG only supported on API 26+, but current API level is " + Build.VERSION.SDK_INT);
                supported = false;
            }
            if ((bufferFormat = (Integer)mutableConfig.retrieveOption(ImageCaptureConfig.OPTION_BUFFER_FORMAT, null)) != null && bufferFormat != 256) {
                Logger.w(TAG, "Software JPEG cannot be used with non-JPEG output buffer format.");
                supported = false;
            }
            if (mutableConfig.retrieveOption(ImageCaptureConfig.OPTION_CAPTURE_PROCESSOR, null) != null) {
                Logger.w(TAG, "CaptureProcessor is set, unable to use software JPEG.");
                supported = false;
            }
            if (!supported) {
                Logger.w(TAG, "Unable to support software JPEG. Disabling.");
                mutableConfig.insertOption(ImageCaptureConfig.OPTION_USE_SOFTWARE_JPEG_ENCODER, false);
            }
            return supported;
        }
        return false;
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void onDetached() {
        this.abortImageCaptureRequests();
        this.clearPipeline();
        this.mUseSoftwareJpeg = false;
        this.mExecutor.shutdown();
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void onAttached() {
        ImageCaptureConfig useCaseConfig = (ImageCaptureConfig)this.getCurrentConfig();
        CaptureConfig.Builder captureBuilder = CaptureConfig.Builder.createFrom(useCaseConfig);
        this.mCaptureConfig = captureBuilder.build();
        this.mCaptureProcessor = useCaseConfig.getCaptureProcessor(null);
        this.mMaxCaptureStages = useCaseConfig.getMaxCaptureStages(2);
        this.mCaptureBundle = useCaseConfig.getCaptureBundle(CaptureBundles.singleDefaultCaptureBundle());
        this.mUseSoftwareJpeg = useCaseConfig.isSoftwareJpegEncoderRequested();
        this.mExecutor = Executors.newFixedThreadPool(1, new ThreadFactory(){
            private final AtomicInteger mId = new AtomicInteger(0);

            @Override
            public Thread newThread(@NonNull Runnable r) {
                return new Thread(r, "CameraX-image_capture_" + this.mId.getAndIncrement());
            }
        });
    }

    @Override
    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected Size onSuggestedResolutionUpdated(@NonNull Size suggestedResolution) {
        this.mSessionConfigBuilder = this.createPipeline(this.getCameraId(), (ImageCaptureConfig)this.getCurrentConfig(), suggestedResolution);
        this.updateSessionConfig(this.mSessionConfigBuilder.build());
        this.notifyActive();
        return suggestedResolution;
    }

    private ListenableFuture<Void> preTakePicture(TakePictureState state) {
        this.lockFlashMode();
        return FutureChain.from(this.getPreCaptureStateIfNeeded()).transformAsync(captureResult -> {
            state.mPreCaptureState = captureResult;
            this.triggerAfIfNeeded(state);
            if (this.isAePrecaptureRequired(state)) {
                return this.triggerAePrecapture(state);
            }
            return Futures.immediateFuture(null);
        }, this.mExecutor).transformAsync(v -> this.check3AConverged(state), this.mExecutor).transform(is3AConverged -> null, this.mExecutor);
    }

    void postTakePicture(TakePictureState state) {
        this.cancelAfAeTrigger(state);
        this.unlockFlashMode();
    }

    private ListenableFuture<CameraCaptureResult> getPreCaptureStateIfNeeded() {
        if (this.mEnableCheck3AConverged || this.getFlashMode() == 0) {
            return this.mSessionCallbackChecker.checkCaptureResult(new CaptureCallbackChecker.CaptureResultChecker<CameraCaptureResult>(){

                @Override
                public CameraCaptureResult check(@NonNull CameraCaptureResult captureResult) {
                    if (Logger.isDebugEnabled(ImageCapture.TAG)) {
                        Logger.d(ImageCapture.TAG, "preCaptureState, AE=" + (Object)((Object)captureResult.getAeState()) + " AF =" + (Object)((Object)captureResult.getAfState()) + " AWB=" + (Object)((Object)captureResult.getAwbState()));
                    }
                    return captureResult;
                }
            });
        }
        return Futures.immediateFuture(null);
    }

    boolean isAePrecaptureRequired(TakePictureState state) {
        switch (this.getFlashMode()) {
            case 1: {
                return true;
            }
            case 0: {
                return state.mPreCaptureState.getAeState() == CameraCaptureMetaData.AeState.FLASH_REQUIRED;
            }
            case 2: {
                return false;
            }
        }
        throw new AssertionError(this.getFlashMode());
    }

    ListenableFuture<Boolean> check3AConverged(TakePictureState state) {
        if (!this.mEnableCheck3AConverged && !state.mIsAePrecaptureTriggered) {
            return Futures.immediateFuture(false);
        }
        return this.mSessionCallbackChecker.checkCaptureResult(new CaptureCallbackChecker.CaptureResultChecker<Boolean>(){

            @Override
            public Boolean check(@NonNull CameraCaptureResult captureResult) {
                if (Logger.isDebugEnabled(ImageCapture.TAG)) {
                    Logger.d(ImageCapture.TAG, "checkCaptureResult, AE=" + (Object)((Object)captureResult.getAeState()) + " AF =" + (Object)((Object)captureResult.getAfState()) + " AWB=" + (Object)((Object)captureResult.getAwbState()));
                }
                if (ImageCapture.this.is3AConverged(captureResult)) {
                    return true;
                }
                return null;
            }
        }, 1000L, false);
    }

    boolean is3AConverged(CameraCaptureResult captureResult) {
        if (captureResult == null) {
            return false;
        }
        boolean isAfReady = captureResult.getAfMode() == CameraCaptureMetaData.AfMode.ON_CONTINUOUS_AUTO || captureResult.getAfMode() == CameraCaptureMetaData.AfMode.OFF || captureResult.getAfMode() == CameraCaptureMetaData.AfMode.UNKNOWN || captureResult.getAfState() == CameraCaptureMetaData.AfState.FOCUSED || captureResult.getAfState() == CameraCaptureMetaData.AfState.LOCKED_FOCUSED || captureResult.getAfState() == CameraCaptureMetaData.AfState.LOCKED_NOT_FOCUSED;
        boolean isAeReady = captureResult.getAeState() == CameraCaptureMetaData.AeState.CONVERGED || captureResult.getAeState() == CameraCaptureMetaData.AeState.FLASH_REQUIRED || captureResult.getAeState() == CameraCaptureMetaData.AeState.UNKNOWN;
        boolean isAwbReady = captureResult.getAwbState() == CameraCaptureMetaData.AwbState.CONVERGED || captureResult.getAwbState() == CameraCaptureMetaData.AwbState.UNKNOWN;
        return isAfReady && isAeReady && isAwbReady;
    }

    void triggerAfIfNeeded(TakePictureState state) {
        if (this.mEnableCheck3AConverged && state.mPreCaptureState.getAfMode() == CameraCaptureMetaData.AfMode.ON_MANUAL_AUTO && state.mPreCaptureState.getAfState() == CameraCaptureMetaData.AfState.INACTIVE) {
            this.triggerAf(state);
        }
    }

    private void triggerAf(TakePictureState state) {
        Logger.d(TAG, "triggerAf");
        state.mIsAfTriggered = true;
        ListenableFuture<CameraCaptureResult> future = this.getCameraControl().triggerAf();
        future.addListener(() -> {}, CameraXExecutors.directExecutor());
    }

    ListenableFuture<CameraCaptureResult> triggerAePrecapture(TakePictureState state) {
        Logger.d(TAG, "triggerAePrecapture");
        state.mIsAePrecaptureTriggered = true;
        return this.getCameraControl().triggerAePrecapture();
    }

    void cancelAfAeTrigger(TakePictureState state) {
        if (!state.mIsAfTriggered && !state.mIsAePrecaptureTriggered) {
            return;
        }
        this.getCameraControl().cancelAfAeTrigger(state.mIsAfTriggered, state.mIsAePrecaptureTriggered);
        state.mIsAfTriggered = false;
        state.mIsAePrecaptureTriggered = false;
    }

    ListenableFuture<Void> issueTakePicture(@NonNull ImageCaptureRequest imageCaptureRequest) {
        CaptureBundle captureBundle;
        Logger.d(TAG, "issueTakePicture");
        ArrayList<ListenableFuture> futureList = new ArrayList<ListenableFuture>();
        ArrayList<CaptureConfig> captureConfigs = new ArrayList<CaptureConfig>();
        String tagBundleKey = null;
        if (this.mProcessingImageReader != null) {
            if (this.mUseSoftwareJpeg) {
                captureBundle = this.getCaptureBundle(CaptureBundles.singleDefaultCaptureBundle());
                if (captureBundle.getCaptureStages().size() > 1) {
                    return Futures.immediateFailedFuture(new IllegalArgumentException("Software JPEG not supported with CaptureBundle size > 1."));
                }
            } else {
                captureBundle = this.getCaptureBundle(null);
            }
            if (captureBundle == null) {
                return Futures.immediateFailedFuture(new IllegalArgumentException("ImageCapture cannot set empty CaptureBundle."));
            }
            if (captureBundle.getCaptureStages().size() > this.mMaxCaptureStages) {
                return Futures.immediateFailedFuture(new IllegalArgumentException("ImageCapture has CaptureStages > Max CaptureStage size"));
            }
            this.mProcessingImageReader.setCaptureBundle(captureBundle);
            tagBundleKey = this.mProcessingImageReader.getTagBundleKey();
        } else {
            captureBundle = this.getCaptureBundle(CaptureBundles.singleDefaultCaptureBundle());
            if (captureBundle.getCaptureStages().size() > 1) {
                return Futures.immediateFailedFuture(new IllegalArgumentException("ImageCapture have no CaptureProcess set with CaptureBundle size > 1."));
            }
        }
        for (CaptureStage captureStage : captureBundle.getCaptureStages()) {
            CaptureConfig.Builder builder = new CaptureConfig.Builder();
            builder.setTemplateType(this.mCaptureConfig.getTemplateType());
            builder.addImplementationOptions(this.mCaptureConfig.getImplementationOptions());
            builder.addAllCameraCaptureCallbacks(this.mSessionConfigBuilder.getSingleCameraCaptureCallbacks());
            builder.addSurface(this.mDeferrableSurface);
            if (new ExifRotationAvailability().isRotationOptionSupported()) {
                builder.addImplementationOption(CaptureConfig.OPTION_ROTATION, imageCaptureRequest.mRotationDegrees);
            }
            builder.addImplementationOption(CaptureConfig.OPTION_JPEG_QUALITY, imageCaptureRequest.mJpegQuality);
            builder.addImplementationOptions(captureStage.getCaptureConfig().getImplementationOptions());
            if (tagBundleKey != null) {
                builder.addTag(tagBundleKey, captureStage.getId());
            }
            builder.addCameraCaptureCallback(this.mMetadataMatchingCaptureCallback);
            ListenableFuture future = CallbackToFutureAdapter.getFuture(completer -> {
                CameraCaptureCallback completerCallback = new CameraCaptureCallback(){

                    @Override
                    public void onCaptureCompleted(@NonNull CameraCaptureResult result) {
                        completer.set(null);
                    }

                    @Override
                    public void onCaptureFailed(@NonNull CameraCaptureFailure failure) {
                        String msg = "Capture request failed with reason " + (Object)((Object)failure.getReason());
                        completer.setException((Throwable)new CaptureFailedException(msg));
                    }

                    @Override
                    public void onCaptureCancelled() {
                        String msg = "Capture request is cancelled because camera is closed";
                        completer.setException((Throwable)new CameraClosedException(msg));
                    }
                };
                builder.addCameraCaptureCallback(completerCallback);
                captureConfigs.add(builder.build());
                return "issueTakePicture[stage=" + captureStage.getId() + "]";
            });
            futureList.add(future);
        }
        this.getCameraControl().submitCaptureRequests(captureConfigs);
        return Futures.transform(Futures.allAsList(futureList), input -> null, CameraXExecutors.directExecutor());
    }

    private CaptureBundle getCaptureBundle(CaptureBundle defaultCaptureBundle) {
        List<CaptureStage> captureStages = this.mCaptureBundle.getCaptureStages();
        if (captureStages == null || captureStages.isEmpty()) {
            return defaultCaptureBundle;
        }
        return CaptureBundles.createCaptureBundle(captureStages);
    }

    public static final class Builder
    implements UseCaseConfig.Builder<ImageCapture, ImageCaptureConfig, Builder>,
    ImageOutputConfig.Builder<Builder>,
    IoConfig.Builder<Builder> {
        private final MutableOptionsBundle mMutableConfig;

        public Builder() {
            this(MutableOptionsBundle.create());
        }

        private Builder(MutableOptionsBundle mutableConfig) {
            this.mMutableConfig = mutableConfig;
            Class oldConfigClass = mutableConfig.retrieveOption(TargetConfig.OPTION_TARGET_CLASS, null);
            if (oldConfigClass != null && !oldConfigClass.equals(ImageCapture.class)) {
                throw new IllegalArgumentException("Invalid target class configuration for " + this + ": " + oldConfigClass);
            }
            this.setTargetClass((Class)ImageCapture.class);
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public static Builder fromConfig(@NonNull Config configuration) {
            return new Builder(MutableOptionsBundle.from(configuration));
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        static Builder fromConfig(@NonNull ImageCaptureConfig configuration) {
            return new Builder(MutableOptionsBundle.from(configuration));
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public MutableConfig getMutableConfig() {
            return this.mMutableConfig;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public ImageCaptureConfig getUseCaseConfig() {
            return new ImageCaptureConfig(OptionsBundle.from(this.mMutableConfig));
        }

        @Override
        @NonNull
        public ImageCapture build() {
            int flashMode;
            if (this.getMutableConfig().retrieveOption(ImageCaptureConfig.OPTION_TARGET_ASPECT_RATIO, null) != null && this.getMutableConfig().retrieveOption(ImageCaptureConfig.OPTION_TARGET_RESOLUTION, null) != null) {
                throw new IllegalArgumentException("Cannot use both setTargetResolution and setTargetAspectRatio on the same config.");
            }
            Integer bufferFormat = this.getMutableConfig().retrieveOption(ImageCaptureConfig.OPTION_BUFFER_FORMAT, null);
            if (bufferFormat != null) {
                Preconditions.checkArgument((this.getMutableConfig().retrieveOption(ImageCaptureConfig.OPTION_CAPTURE_PROCESSOR, null) == null ? 1 : 0) != 0, (Object)"Cannot set buffer format with CaptureProcessor defined.");
                this.getMutableConfig().insertOption(ImageInputConfig.OPTION_INPUT_FORMAT, bufferFormat);
            } else if (this.getMutableConfig().retrieveOption(ImageCaptureConfig.OPTION_CAPTURE_PROCESSOR, null) != null) {
                this.getMutableConfig().insertOption(ImageInputConfig.OPTION_INPUT_FORMAT, 35);
            } else {
                this.getMutableConfig().insertOption(ImageInputConfig.OPTION_INPUT_FORMAT, 256);
            }
            ImageCapture imageCapture = new ImageCapture(this.getUseCaseConfig());
            Size targetResolution = this.getMutableConfig().retrieveOption(ImageCaptureConfig.OPTION_TARGET_RESOLUTION, null);
            if (targetResolution != null) {
                imageCapture.setCropAspectRatio(new Rational(targetResolution.getWidth(), targetResolution.getHeight()));
            }
            Preconditions.checkArgument((this.getMutableConfig().retrieveOption(ImageCaptureConfig.OPTION_MAX_CAPTURE_STAGES, 2) >= 1 ? 1 : 0) != 0, (Object)"Maximum outstanding image count must be at least 1");
            Preconditions.checkNotNull((Object)this.getMutableConfig().retrieveOption(ImageCaptureConfig.OPTION_IO_EXECUTOR, CameraXExecutors.ioExecutor()), (Object)"The IO executor can't be null");
            if (this.getMutableConfig().containsOption(ImageCaptureConfig.OPTION_FLASH_MODE) && (flashMode = this.getMutableConfig().retrieveOption(ImageCaptureConfig.OPTION_FLASH_MODE).intValue()) != 0 && flashMode != 1 && flashMode != 2) {
                throw new IllegalArgumentException("The flash mode is not allowed to set: " + flashMode);
            }
            return imageCapture;
        }

        @NonNull
        public Builder setCaptureMode(int captureMode) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_IMAGE_CAPTURE_MODE, captureMode);
            return this;
        }

        @NonNull
        public Builder setFlashMode(int flashMode) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_FLASH_MODE, flashMode);
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setCaptureBundle(@NonNull CaptureBundle captureBundle) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_CAPTURE_BUNDLE, captureBundle);
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setCaptureProcessor(@NonNull CaptureProcessor captureProcessor) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_CAPTURE_PROCESSOR, captureProcessor);
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setBufferFormat(int bufferImageFormat) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_BUFFER_FORMAT, bufferImageFormat);
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setMaxCaptureStages(int maxCaptureStages) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_MAX_CAPTURE_STAGES, maxCaptureStages);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setSupportedResolutions(@NonNull List<Pair<Integer, Size[]>> resolutions) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_SUPPORTED_RESOLUTIONS, resolutions);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setTargetClass(@NonNull Class<ImageCapture> targetClass) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_TARGET_CLASS, targetClass);
            if (null == this.getMutableConfig().retrieveOption(ImageCaptureConfig.OPTION_TARGET_NAME, null)) {
                String targetName = targetClass.getCanonicalName() + "-" + UUID.randomUUID();
                this.setTargetName(targetName);
            }
            return this;
        }

        @Override
        @NonNull
        public Builder setTargetName(@NonNull String targetName) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_TARGET_NAME, targetName);
            return this;
        }

        @Override
        @NonNull
        public Builder setTargetAspectRatio(int aspectRatio) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_TARGET_ASPECT_RATIO, aspectRatio);
            return this;
        }

        @Override
        @NonNull
        public Builder setTargetRotation(int rotation) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_TARGET_ROTATION, rotation);
            return this;
        }

        @Override
        @NonNull
        public Builder setTargetResolution(@NonNull Size resolution) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_TARGET_RESOLUTION, resolution);
            return this;
        }

        @Override
        @NonNull
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public Builder setDefaultResolution(@NonNull Size resolution) {
            this.getMutableConfig().insertOption(ImageOutputConfig.OPTION_DEFAULT_RESOLUTION, resolution);
            return this;
        }

        @Override
        @NonNull
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public Builder setMaxResolution(@NonNull Size resolution) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_MAX_RESOLUTION, resolution);
            return this;
        }

        @NonNull
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public Builder setImageReaderProxyProvider(@NonNull ImageReaderProxyProvider imageReaderProxyProvider) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_IMAGE_READER_PROXY_PROVIDER, imageReaderProxyProvider);
            return this;
        }

        @NonNull
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public Builder setSoftwareJpegEncoderRequested(boolean requestSoftwareJpeg) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_USE_SOFTWARE_JPEG_ENCODER, requestSoftwareJpeg);
            return this;
        }

        @Override
        @NonNull
        public Builder setIoExecutor(@NonNull Executor executor) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_IO_EXECUTOR, executor);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setDefaultSessionConfig(@NonNull SessionConfig sessionConfig) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_DEFAULT_SESSION_CONFIG, sessionConfig);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setDefaultCaptureConfig(@NonNull CaptureConfig captureConfig) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_DEFAULT_CAPTURE_CONFIG, captureConfig);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setSessionOptionUnpacker(@NonNull SessionConfig.OptionUnpacker optionUnpacker) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_SESSION_CONFIG_UNPACKER, optionUnpacker);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setCaptureOptionUnpacker(@NonNull CaptureConfig.OptionUnpacker optionUnpacker) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_CAPTURE_CONFIG_UNPACKER, optionUnpacker);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setCameraSelector(@NonNull CameraSelector cameraSelector) {
            this.getMutableConfig().insertOption(UseCaseConfig.OPTION_CAMERA_SELECTOR, cameraSelector);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setSurfaceOccupancyPriority(int priority) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_SURFACE_OCCUPANCY_PRIORITY, priority);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setUseCaseEventCallback(@NonNull UseCase.EventCallback useCaseEventCallback) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_USE_CASE_EVENT_CALLBACK, useCaseEventCallback);
            return this;
        }
    }

    @VisibleForTesting
    static class ImageCaptureRequest {
        final int mRotationDegrees;
        @IntRange(from=1L, to=100L)
        final int mJpegQuality;
        private final Rational mTargetRatio;
        @NonNull
        private final Executor mListenerExecutor;
        @NonNull
        private final OnImageCapturedCallback mCallback;
        AtomicBoolean mDispatched = new AtomicBoolean(false);
        private final Rect mViewPortCropRect;

        ImageCaptureRequest(int rotationDegrees, @IntRange(from=1L, to=100L) int jpegQuality, Rational targetRatio, @Nullable Rect viewPortCropRect, @NonNull Executor executor, @NonNull OnImageCapturedCallback callback) {
            this.mRotationDegrees = rotationDegrees;
            this.mJpegQuality = jpegQuality;
            if (targetRatio != null) {
                Preconditions.checkArgument((!targetRatio.isZero() ? 1 : 0) != 0, (Object)"Target ratio cannot be zero");
                Preconditions.checkArgument((targetRatio.floatValue() > 0.0f ? 1 : 0) != 0, (Object)"Target ratio must be positive");
            }
            this.mTargetRatio = targetRatio;
            this.mViewPortCropRect = viewPortCropRect;
            this.mListenerExecutor = executor;
            this.mCallback = callback;
        }

        void dispatchImage(ImageProxy image) {
            Size dispatchResolution;
            if (!this.mDispatched.compareAndSet(false, true)) {
                image.close();
                return;
            }
            int dispatchRotationDegrees = 0;
            if (new ExifRotationAvailability().shouldUseExifOrientation(image)) {
                try {
                    ImageProxy.PlaneProxy[] planes = image.getPlanes();
                    ByteBuffer buffer = planes[0].getBuffer();
                    buffer.rewind();
                    byte[] data = new byte[buffer.capacity()];
                    buffer.get(data);
                    Exif exif = Exif.createFromInputStream(new ByteArrayInputStream(data));
                    buffer.rewind();
                    dispatchResolution = new Size(exif.getWidth(), exif.getHeight());
                    dispatchRotationDegrees = exif.getRotation();
                }
                catch (IOException e) {
                    this.notifyCallbackError(1, "Unable to parse JPEG exif", e);
                    image.close();
                    return;
                }
            } else {
                dispatchResolution = new Size(image.getWidth(), image.getHeight());
                dispatchRotationDegrees = this.mRotationDegrees;
            }
            ImageInfo imageInfo = ImmutableImageInfo.create(image.getImageInfo().getTagBundle(), image.getImageInfo().getTimestamp(), dispatchRotationDegrees);
            SettableImageProxy dispatchedImageProxy = new SettableImageProxy(image, dispatchResolution, imageInfo);
            if (this.mViewPortCropRect != null) {
                dispatchedImageProxy.setCropRect(ImageCaptureRequest.getDispatchCropRect(this.mViewPortCropRect, this.mRotationDegrees, dispatchResolution, dispatchRotationDegrees));
            } else if (this.mTargetRatio != null) {
                Size sourceSize;
                Rational dispatchRatio = this.mTargetRatio;
                if (dispatchRotationDegrees % 180 != 0) {
                    dispatchRatio = new Rational(this.mTargetRatio.getDenominator(), this.mTargetRatio.getNumerator());
                }
                if (ImageUtil.isAspectRatioValid(sourceSize = new Size(dispatchedImageProxy.getWidth(), dispatchedImageProxy.getHeight()), dispatchRatio)) {
                    dispatchedImageProxy.setCropRect(ImageUtil.computeCropRectFromAspectRatio(sourceSize, dispatchRatio));
                }
            }
            try {
                this.mListenerExecutor.execute(() -> this.mCallback.onCaptureSuccess(dispatchedImageProxy));
            }
            catch (RejectedExecutionException e) {
                Logger.e(ImageCapture.TAG, "Unable to post to the supplied executor.");
                image.close();
            }
        }

        @NonNull
        static Rect getDispatchCropRect(@NonNull Rect surfaceCropRect, int surfaceToOutputDegrees, @NonNull Size dispatchResolution, int dispatchToOutputDegrees) {
            Matrix matrix = new Matrix();
            matrix.setRotate((float)(dispatchToOutputDegrees - surfaceToOutputDegrees));
            float[] vertexes = ImageUtil.sizeToVertexes(dispatchResolution);
            matrix.mapPoints(vertexes);
            float left = ImageUtil.min(vertexes[0], vertexes[2], vertexes[4], vertexes[6]);
            float top = ImageUtil.min(vertexes[1], vertexes[3], vertexes[5], vertexes[7]);
            matrix.postTranslate(-left, -top);
            matrix.invert(matrix);
            RectF dispatchCropRectF = new RectF();
            matrix.mapRect(dispatchCropRectF, new RectF(surfaceCropRect));
            dispatchCropRectF.sort();
            Rect dispatchCropRect = new Rect();
            dispatchCropRectF.round(dispatchCropRect);
            return dispatchCropRect;
        }

        void notifyCallbackError(int imageCaptureError, String message, Throwable cause) {
            if (!this.mDispatched.compareAndSet(false, true)) {
                return;
            }
            try {
                this.mListenerExecutor.execute(() -> this.mCallback.onError(new ImageCaptureException(imageCaptureError, message, cause)));
            }
            catch (RejectedExecutionException e) {
                Logger.e(ImageCapture.TAG, "Unable to post to the supplied executor.");
            }
        }
    }

    static final class CaptureCallbackChecker
    extends CameraCaptureCallback {
        private static final long NO_TIMEOUT = 0L;
        private final Set<CaptureResultListener> mCaptureResultListeners = new HashSet<CaptureResultListener>();

        CaptureCallbackChecker() {
        }

        @Override
        public void onCaptureCompleted(@NonNull CameraCaptureResult cameraCaptureResult) {
            this.deliverCaptureResultToListeners(cameraCaptureResult);
        }

        <T> ListenableFuture<T> checkCaptureResult(CaptureResultChecker<T> checker) {
            return this.checkCaptureResult(checker, 0L, null);
        }

        <T> ListenableFuture<T> checkCaptureResult(final CaptureResultChecker<T> checker, final long timeoutInMs, final T defValue) {
            if (timeoutInMs < 0L) {
                throw new IllegalArgumentException("Invalid timeout value: " + timeoutInMs);
            }
            final long startTimeInMs = timeoutInMs != 0L ? SystemClock.elapsedRealtime() : 0L;
            return CallbackToFutureAdapter.getFuture(completer -> {
                this.addListener(new CaptureResultListener(){

                    @Override
                    public boolean onCaptureResult(@NonNull CameraCaptureResult captureResult) {
                        Object result = checker.check(captureResult);
                        if (result != null) {
                            completer.set(result);
                            return true;
                        }
                        if (startTimeInMs > 0L && SystemClock.elapsedRealtime() - startTimeInMs > timeoutInMs) {
                            completer.set(defValue);
                            return true;
                        }
                        return false;
                    }
                });
                return "checkCaptureResult";
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void deliverCaptureResultToListeners(@NonNull CameraCaptureResult captureResult) {
            Set<CaptureResultListener> set = this.mCaptureResultListeners;
            synchronized (set) {
                HashSet<CaptureResultListener> removeSet = null;
                for (CaptureResultListener listener : new HashSet<CaptureResultListener>(this.mCaptureResultListeners)) {
                    if (!listener.onCaptureResult(captureResult)) continue;
                    if (removeSet == null) {
                        removeSet = new HashSet<CaptureResultListener>();
                    }
                    removeSet.add(listener);
                }
                if (removeSet != null) {
                    this.mCaptureResultListeners.removeAll(removeSet);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addListener(CaptureResultListener listener) {
            Set<CaptureResultListener> set = this.mCaptureResultListeners;
            synchronized (set) {
                this.mCaptureResultListeners.add(listener);
            }
        }

        private static interface CaptureResultListener {
            public boolean onCaptureResult(@NonNull CameraCaptureResult var1);
        }

        public static interface CaptureResultChecker<T> {
            @Nullable
            public T check(@NonNull CameraCaptureResult var1);
        }
    }

    static final class TakePictureState {
        CameraCaptureResult mPreCaptureState = CameraCaptureResult.EmptyCameraCaptureResult.create();
        boolean mIsAfTriggered = false;
        boolean mIsAePrecaptureTriggered = false;

        TakePictureState() {
        }
    }

    public static final class Metadata {
        private boolean mIsReversedHorizontal;
        private boolean mIsReversedHorizontalSet = false;
        private boolean mIsReversedVertical;
        @Nullable
        private Location mLocation;

        public boolean isReversedHorizontal() {
            return this.mIsReversedHorizontal;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public boolean isReversedHorizontalSet() {
            return this.mIsReversedHorizontalSet;
        }

        public void setReversedHorizontal(boolean isReversedHorizontal) {
            this.mIsReversedHorizontal = isReversedHorizontal;
            this.mIsReversedHorizontalSet = true;
        }

        public boolean isReversedVertical() {
            return this.mIsReversedVertical;
        }

        public void setReversedVertical(boolean isReversedVertical) {
            this.mIsReversedVertical = isReversedVertical;
        }

        @Nullable
        public Location getLocation() {
            return this.mLocation;
        }

        public void setLocation(@Nullable Location location) {
            this.mLocation = location;
        }
    }

    public static class OutputFileResults {
        @Nullable
        private Uri mSavedUri;

        OutputFileResults(@Nullable Uri savedUri) {
            this.mSavedUri = savedUri;
        }

        @Nullable
        public Uri getSavedUri() {
            return this.mSavedUri;
        }
    }

    public static final class OutputFileOptions {
        @Nullable
        private final File mFile;
        @Nullable
        private final ContentResolver mContentResolver;
        @Nullable
        private final Uri mSaveCollection;
        @Nullable
        private final ContentValues mContentValues;
        @Nullable
        private final OutputStream mOutputStream;
        @NonNull
        private final Metadata mMetadata;

        OutputFileOptions(@Nullable File file, @Nullable ContentResolver contentResolver, @Nullable Uri saveCollection, @Nullable ContentValues contentValues, @Nullable OutputStream outputStream, @Nullable Metadata metadata) {
            this.mFile = file;
            this.mContentResolver = contentResolver;
            this.mSaveCollection = saveCollection;
            this.mContentValues = contentValues;
            this.mOutputStream = outputStream;
            this.mMetadata = metadata == null ? new Metadata() : metadata;
        }

        @Nullable
        File getFile() {
            return this.mFile;
        }

        @Nullable
        ContentResolver getContentResolver() {
            return this.mContentResolver;
        }

        @Nullable
        Uri getSaveCollection() {
            return this.mSaveCollection;
        }

        @Nullable
        ContentValues getContentValues() {
            return this.mContentValues;
        }

        @Nullable
        OutputStream getOutputStream() {
            return this.mOutputStream;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Metadata getMetadata() {
            return this.mMetadata;
        }

        public static final class Builder {
            @Nullable
            private File mFile;
            @Nullable
            private ContentResolver mContentResolver;
            @Nullable
            private Uri mSaveCollection;
            @Nullable
            private ContentValues mContentValues;
            @Nullable
            private OutputStream mOutputStream;
            @Nullable
            private Metadata mMetadata;

            public Builder(@NonNull File file) {
                this.mFile = file;
            }

            public Builder(@NonNull ContentResolver contentResolver, @NonNull Uri saveCollection, @NonNull ContentValues contentValues) {
                this.mContentResolver = contentResolver;
                this.mSaveCollection = saveCollection;
                this.mContentValues = contentValues;
            }

            public Builder(@NonNull OutputStream outputStream) {
                this.mOutputStream = outputStream;
            }

            @NonNull
            public Builder setMetadata(@NonNull Metadata metadata) {
                this.mMetadata = metadata;
                return this;
            }

            @NonNull
            public OutputFileOptions build() {
                return new OutputFileOptions(this.mFile, this.mContentResolver, this.mSaveCollection, this.mContentValues, this.mOutputStream, this.mMetadata);
            }
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final class Defaults
    implements ConfigProvider<ImageCaptureConfig> {
        private static final int DEFAULT_SURFACE_OCCUPANCY_PRIORITY = 4;
        private static final int DEFAULT_ASPECT_RATIO = 0;
        private static final ImageCaptureConfig DEFAULT_CONFIG;

        @Override
        @NonNull
        public ImageCaptureConfig getConfig() {
            return DEFAULT_CONFIG;
        }

        static {
            Builder builder = new Builder().setSurfaceOccupancyPriority(4).setTargetAspectRatio(0);
            DEFAULT_CONFIG = builder.getUseCaseConfig();
        }
    }

    public static abstract class OnImageCapturedCallback {
        public void onCaptureSuccess(@NonNull ImageProxy image) {
        }

        public void onError(@NonNull ImageCaptureException exception) {
        }
    }

    public static interface OnImageSavedCallback {
        public void onImageSaved(@NonNull OutputFileResults var1);

        public void onError(@NonNull ImageCaptureException var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface FlashMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface CaptureMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface ImageCaptureError {
    }

    static final class CaptureFailedException
    extends RuntimeException {
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        CaptureFailedException(String s, Throwable e) {
            super(s, e);
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        CaptureFailedException(String s) {
            super(s);
        }
    }

    @VisibleForTesting
    static class ImageCaptureRequestProcessor
    implements ForwardingImageProxy.OnImageCloseListener {
        @GuardedBy(value="mLock")
        private final Deque<ImageCaptureRequest> mPendingRequests = new ArrayDeque<ImageCaptureRequest>();
        @GuardedBy(value="mLock")
        ImageCaptureRequest mCurrentRequest = null;
        @GuardedBy(value="mLock")
        ListenableFuture<ImageProxy> mCurrentRequestFuture = null;
        @GuardedBy(value="mLock")
        int mOutstandingImages = 0;
        @GuardedBy(value="mLock")
        private final ImageCaptor mImageCaptor;
        private final int mMaxImages;
        final Object mLock = new Object();

        ImageCaptureRequestProcessor(int maxImages, @NonNull ImageCaptor imageCaptor) {
            this.mMaxImages = maxImages;
            this.mImageCaptor = imageCaptor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sendRequest(@NonNull ImageCaptureRequest imageCaptureRequest) {
            Object object = this.mLock;
            synchronized (object) {
                this.mPendingRequests.offer(imageCaptureRequest);
                Logger.d(ImageCapture.TAG, String.format(Locale.US, "Send image capture request [current, pending] = [%d, %d]", this.mCurrentRequest != null ? 1 : 0, this.mPendingRequests.size()));
                this.processNextRequest();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancelRequests(@NonNull Throwable throwable) {
            ArrayList<ImageCaptureRequest> pendingRequests;
            ListenableFuture<ImageProxy> currentRequestFuture;
            ImageCaptureRequest currentRequest;
            Iterator iterator = this.mLock;
            synchronized (iterator) {
                currentRequest = this.mCurrentRequest;
                this.mCurrentRequest = null;
                currentRequestFuture = this.mCurrentRequestFuture;
                this.mCurrentRequestFuture = null;
                pendingRequests = new ArrayList<ImageCaptureRequest>(this.mPendingRequests);
                this.mPendingRequests.clear();
            }
            if (currentRequest != null && currentRequestFuture != null) {
                currentRequest.notifyCallbackError(ImageCapture.getError(throwable), throwable.getMessage(), throwable);
                currentRequestFuture.cancel(true);
            }
            for (ImageCaptureRequest request : pendingRequests) {
                request.notifyCallbackError(ImageCapture.getError(throwable), throwable.getMessage(), throwable);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onImageClose(ImageProxy image) {
            Object object = this.mLock;
            synchronized (object) {
                --this.mOutstandingImages;
                this.processNextRequest();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void processNextRequest() {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mCurrentRequest != null) {
                    return;
                }
                if (this.mOutstandingImages >= this.mMaxImages) {
                    Logger.w(ImageCapture.TAG, "Too many acquire images. Close image to be able to process next.");
                    return;
                }
                final ImageCaptureRequest imageCaptureRequest = this.mPendingRequests.poll();
                if (imageCaptureRequest == null) {
                    return;
                }
                this.mCurrentRequest = imageCaptureRequest;
                this.mCurrentRequestFuture = this.mImageCaptor.capture(imageCaptureRequest);
                Futures.addCallback(this.mCurrentRequestFuture, new FutureCallback<ImageProxy>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onSuccess(@Nullable ImageProxy image) {
                        Object object = mLock;
                        synchronized (object) {
                            Preconditions.checkNotNull((Object)image);
                            SingleCloseImageProxy wrappedImage = new SingleCloseImageProxy(image);
                            wrappedImage.addOnImageCloseListener(this);
                            ++mOutstandingImages;
                            imageCaptureRequest.dispatchImage(wrappedImage);
                            mCurrentRequest = null;
                            mCurrentRequestFuture = null;
                            this.processNextRequest();
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onFailure(Throwable t) {
                        Object object = mLock;
                        synchronized (object) {
                            if (!(t instanceof CancellationException)) {
                                imageCaptureRequest.notifyCallbackError(ImageCapture.getError(t), t != null ? t.getMessage() : "Unknown error", t);
                            }
                            mCurrentRequest = null;
                            mCurrentRequestFuture = null;
                            this.processNextRequest();
                        }
                    }
                }, CameraXExecutors.directExecutor());
            }
        }

        static interface ImageCaptor {
            @NonNull
            public ListenableFuture<ImageProxy> capture(@NonNull ImageCaptureRequest var1);
        }
    }
}

