/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl;

import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.core.CameraSelector;
import androidx.camera.core.Logger;
import androidx.camera.core.impl.CameraRepository;

public final class CameraValidator {
    private static final String TAG = "CameraValidator";

    private CameraValidator() {
    }

    public static void validateCameras(@NonNull Context context, @NonNull CameraRepository cameraRepository) throws CameraIdListIncorrectException {
        PackageManager pm = context.getPackageManager();
        Logger.d(TAG, "Verifying camera lens facing on " + Build.DEVICE);
        try {
            if (pm.hasSystemFeature("android.hardware.camera")) {
                CameraSelector.DEFAULT_BACK_CAMERA.select(cameraRepository.getCameras());
            }
            if (pm.hasSystemFeature("android.hardware.camera.front")) {
                CameraSelector.DEFAULT_FRONT_CAMERA.select(cameraRepository.getCameras());
            }
        }
        catch (IllegalArgumentException e) {
            Logger.e(TAG, "Camera LensFacing verification failed, existing cameras: " + cameraRepository.getCameras());
            throw new CameraIdListIncorrectException("Expected camera missing from device.", e);
        }
    }

    public static class CameraIdListIncorrectException
    extends Exception {
        public CameraIdListIncorrectException(@Nullable String message, @Nullable Throwable cause) {
            super(message, cause);
        }
    }
}

