/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.core.impl.CameraCaptureCallback;
import androidx.camera.core.impl.Config;
import androidx.camera.core.impl.DeferrableSurface;
import androidx.camera.core.impl.MultiValueSet;
import androidx.camera.core.impl.MutableConfig;
import androidx.camera.core.impl.MutableOptionsBundle;
import androidx.camera.core.impl.MutableTagBundle;
import androidx.camera.core.impl.OptionsBundle;
import androidx.camera.core.impl.TagBundle;
import androidx.camera.core.impl.UseCaseConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public final class CaptureConfig {
    public static final Config.Option<Integer> OPTION_ROTATION = Config.Option.create("camerax.core.captureConfig.rotation", Integer.TYPE);
    public static final Config.Option<Integer> OPTION_JPEG_QUALITY = Config.Option.create("camerax.core.captureConfig.jpegQuality", Integer.class);
    final List<DeferrableSurface> mSurfaces;
    final Config mImplementationOptions;
    final int mTemplateType;
    final List<CameraCaptureCallback> mCameraCaptureCallbacks;
    private final boolean mUseRepeatingSurface;
    @NonNull
    private final TagBundle mTagBundle;

    CaptureConfig(List<DeferrableSurface> surfaces, Config implementationOptions, int templateType, List<CameraCaptureCallback> cameraCaptureCallbacks, boolean useRepeatingSurface, @NonNull TagBundle tagBundle) {
        this.mSurfaces = surfaces;
        this.mImplementationOptions = implementationOptions;
        this.mTemplateType = templateType;
        this.mCameraCaptureCallbacks = Collections.unmodifiableList(cameraCaptureCallbacks);
        this.mUseRepeatingSurface = useRepeatingSurface;
        this.mTagBundle = tagBundle;
    }

    @NonNull
    public static CaptureConfig defaultEmptyCaptureConfig() {
        return new Builder().build();
    }

    @NonNull
    public List<DeferrableSurface> getSurfaces() {
        return Collections.unmodifiableList(this.mSurfaces);
    }

    @NonNull
    public Config getImplementationOptions() {
        return this.mImplementationOptions;
    }

    public int getTemplateType() {
        return this.mTemplateType;
    }

    public boolean isUseRepeatingSurface() {
        return this.mUseRepeatingSurface;
    }

    @NonNull
    public List<CameraCaptureCallback> getCameraCaptureCallbacks() {
        return this.mCameraCaptureCallbacks;
    }

    @NonNull
    public TagBundle getTagBundle() {
        return this.mTagBundle;
    }

    public static final class Builder {
        private final Set<DeferrableSurface> mSurfaces = new HashSet<DeferrableSurface>();
        private MutableConfig mImplementationOptions = MutableOptionsBundle.create();
        private int mTemplateType = -1;
        private List<CameraCaptureCallback> mCameraCaptureCallbacks = new ArrayList<CameraCaptureCallback>();
        private boolean mUseRepeatingSurface = false;
        private MutableTagBundle mMutableTagBundle = MutableTagBundle.create();

        public Builder() {
        }

        private Builder(CaptureConfig base) {
            this.mSurfaces.addAll(base.mSurfaces);
            this.mImplementationOptions = MutableOptionsBundle.from(base.mImplementationOptions);
            this.mTemplateType = base.mTemplateType;
            this.mCameraCaptureCallbacks.addAll(base.getCameraCaptureCallbacks());
            this.mUseRepeatingSurface = base.isUseRepeatingSurface();
            this.mMutableTagBundle = MutableTagBundle.from(base.getTagBundle());
        }

        @NonNull
        public static Builder createFrom(@NonNull UseCaseConfig<?> config) {
            OptionUnpacker unpacker = config.getCaptureOptionUnpacker(null);
            if (unpacker == null) {
                throw new IllegalStateException("Implementation is missing option unpacker for " + config.getTargetName(config.toString()));
            }
            Builder builder = new Builder();
            unpacker.unpack(config, builder);
            return builder;
        }

        @NonNull
        public static Builder from(@NonNull CaptureConfig base) {
            return new Builder(base);
        }

        public int getTemplateType() {
            return this.mTemplateType;
        }

        public void setTemplateType(int templateType) {
            this.mTemplateType = templateType;
        }

        public void addCameraCaptureCallback(@NonNull CameraCaptureCallback cameraCaptureCallback) {
            if (this.mCameraCaptureCallbacks.contains(cameraCaptureCallback)) {
                throw new IllegalArgumentException("duplicate camera capture callback");
            }
            this.mCameraCaptureCallbacks.add(cameraCaptureCallback);
        }

        public void addAllCameraCaptureCallbacks(@NonNull Collection<CameraCaptureCallback> cameraCaptureCallbacks) {
            for (CameraCaptureCallback c : cameraCaptureCallbacks) {
                this.addCameraCaptureCallback(c);
            }
        }

        public void addSurface(@NonNull DeferrableSurface surface) {
            this.mSurfaces.add(surface);
        }

        public void removeSurface(@NonNull DeferrableSurface surface) {
            this.mSurfaces.remove(surface);
        }

        public void clearSurfaces() {
            this.mSurfaces.clear();
        }

        @NonNull
        public Set<DeferrableSurface> getSurfaces() {
            return this.mSurfaces;
        }

        public void setImplementationOptions(@NonNull Config config) {
            this.mImplementationOptions = MutableOptionsBundle.from(config);
        }

        public void addImplementationOptions(@NonNull Config config) {
            Iterator<Config.Option<?>> iterator = config.listOptions().iterator();
            while (iterator.hasNext()) {
                Config.Option<?> option;
                Config.Option<?> objectOpt = option = iterator.next();
                Object existValue = this.mImplementationOptions.retrieveOption(objectOpt, null);
                Object newValue = config.retrieveOption(objectOpt);
                if (existValue instanceof MultiValueSet) {
                    ((MultiValueSet)existValue).addAll(((MultiValueSet)newValue).getAllItems());
                    continue;
                }
                if (newValue instanceof MultiValueSet) {
                    newValue = ((MultiValueSet)newValue).clone();
                }
                this.mImplementationOptions.insertOption(objectOpt, config.getOptionPriority(option), newValue);
            }
        }

        public <T> void addImplementationOption(@NonNull Config.Option<T> option, @NonNull T value) {
            this.mImplementationOptions.insertOption(option, value);
        }

        @NonNull
        public Config getImplementationOptions() {
            return this.mImplementationOptions;
        }

        boolean isUseRepeatingSurface() {
            return this.mUseRepeatingSurface;
        }

        public void setUseRepeatingSurface(boolean useRepeatingSurface) {
            this.mUseRepeatingSurface = useRepeatingSurface;
        }

        @Nullable
        public Integer getTag(@NonNull String key) {
            return this.mMutableTagBundle.getTag(key);
        }

        public void addTag(@NonNull String key, @NonNull Integer tag) {
            this.mMutableTagBundle.putTag(key, tag);
        }

        public void addAllTags(@NonNull TagBundle bundle) {
            this.mMutableTagBundle.addTagBundle(bundle);
        }

        @NonNull
        public CaptureConfig build() {
            return new CaptureConfig(new ArrayList<DeferrableSurface>(this.mSurfaces), OptionsBundle.from(this.mImplementationOptions), this.mTemplateType, this.mCameraCaptureCallbacks, this.mUseRepeatingSurface, TagBundle.from(this.mMutableTagBundle));
        }
    }

    public static interface OptionUnpacker {
        public void unpack(@NonNull UseCaseConfig<?> var1, @NonNull Builder var2);
    }
}

