/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl;

import android.util.ArrayMap;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.core.impl.Config;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class OptionsBundle
implements Config {
    protected static final Comparator<Config.Option<?>> ID_COMPARE = (o1, o2) -> o1.getId().compareTo(o2.getId());
    private static final OptionsBundle EMPTY_BUNDLE = new OptionsBundle(new TreeMap(ID_COMPARE));
    protected final TreeMap<Config.Option<?>, Map<Config.OptionPriority, Object>> mOptions;

    OptionsBundle(TreeMap<Config.Option<?>, Map<Config.OptionPriority, Object>> options) {
        this.mOptions = options;
    }

    @NonNull
    public static OptionsBundle from(@NonNull Config otherConfig) {
        if (OptionsBundle.class.equals(otherConfig.getClass())) {
            return (OptionsBundle)otherConfig;
        }
        TreeMap persistentOptions = new TreeMap(ID_COMPARE);
        for (Config.Option<?> opt : otherConfig.listOptions()) {
            Set<Config.OptionPriority> priorities = otherConfig.getPriorities(opt);
            ArrayMap valuesMap = new ArrayMap();
            for (Config.OptionPriority priority : priorities) {
                valuesMap.put(priority, otherConfig.retrieveOptionWithPriority(opt, priority));
            }
            persistentOptions.put(opt, (Map<Config.OptionPriority, Object>)valuesMap);
        }
        return new OptionsBundle(persistentOptions);
    }

    @NonNull
    public static OptionsBundle emptyBundle() {
        return EMPTY_BUNDLE;
    }

    @Override
    @NonNull
    public Set<Config.Option<?>> listOptions() {
        return Collections.unmodifiableSet(this.mOptions.keySet());
    }

    @Override
    public boolean containsOption(@NonNull Config.Option<?> id) {
        return this.mOptions.containsKey(id);
    }

    @Override
    @Nullable
    public <ValueT> ValueT retrieveOption(@NonNull Config.Option<ValueT> id) {
        Map<Config.OptionPriority, Object> values = this.mOptions.get(id);
        if (values == null) {
            throw new IllegalArgumentException("Option does not exist: " + id);
        }
        Config.OptionPriority highestPrirotiy = Collections.min(values.keySet());
        Object value = values.get((Object)highestPrirotiy);
        return (ValueT)value;
    }

    @Override
    @Nullable
    public <ValueT> ValueT retrieveOption(@NonNull Config.Option<ValueT> id, @Nullable ValueT valueIfMissing) {
        try {
            return this.retrieveOption(id);
        }
        catch (IllegalArgumentException e) {
            return valueIfMissing;
        }
    }

    @Override
    @Nullable
    public <ValueT> ValueT retrieveOptionWithPriority(@NonNull Config.Option<ValueT> id, @NonNull Config.OptionPriority priority) {
        Map<Config.OptionPriority, Object> values = this.mOptions.get(id);
        if (values == null) {
            throw new IllegalArgumentException("Option does not exist: " + id);
        }
        if (!values.containsKey((Object)priority)) {
            throw new IllegalArgumentException("Option does not exist: " + id + " with priority=" + (Object)((Object)priority));
        }
        Object value = values.get((Object)priority);
        return (ValueT)value;
    }

    @Override
    @NonNull
    public Config.OptionPriority getOptionPriority(@NonNull Config.Option<?> opt) {
        Map<Config.OptionPriority, Object> values = this.mOptions.get(opt);
        if (values == null) {
            throw new IllegalArgumentException("Option does not exist: " + opt);
        }
        Config.OptionPriority highestPrirotiy = Collections.min(values.keySet());
        return highestPrirotiy;
    }

    @Override
    public void findOptions(@NonNull String idStem, @NonNull Config.OptionMatcher matcher) {
        Config.Option query = Config.Option.create(idStem, Void.class);
        for (Map.Entry entry : this.mOptions.tailMap(query).entrySet()) {
            Config.Option option;
            if (!entry.getKey().getId().startsWith(idStem) || !matcher.onOptionMatched(option = entry.getKey())) break;
        }
    }

    @Override
    @NonNull
    public Set<Config.OptionPriority> getPriorities(@NonNull Config.Option<?> opt) {
        Map<Config.OptionPriority, Object> values = this.mOptions.get(opt);
        if (values == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(values.keySet());
    }
}

