/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import android.media.ImageReader;
import android.util.Size;
import android.view.Surface;
import androidx.annotation.NonNull;
import androidx.camera.core.AndroidImageReaderProxy;
import androidx.camera.core.ImageInfo;
import androidx.camera.core.ImageProxy;
import androidx.camera.core.SettableImageProxy;
import androidx.camera.core.SettableImageProxyBundle;
import androidx.camera.core.impl.CaptureProcessor;
import androidx.camera.core.impl.ImageProxyBundle;
import androidx.camera.core.impl.ImageReaderProxy;
import androidx.core.util.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;

class CaptureProcessorPipeline
implements CaptureProcessor {
    private final CaptureProcessor mPreCaptureProcessor;
    private final CaptureProcessor mPostCaptureProcessor;
    private final Executor mExecutor;
    private final int mMaxImages;
    private ImageReaderProxy mIntermediateImageReader = null;
    private ImageInfo mSourceImageInfo = null;

    CaptureProcessorPipeline(@NonNull CaptureProcessor preCaptureProcessor, int maxImages, @NonNull CaptureProcessor postCaptureProcessor, @NonNull Executor executor) {
        this.mPreCaptureProcessor = preCaptureProcessor;
        this.mPostCaptureProcessor = postCaptureProcessor;
        this.mExecutor = executor;
        this.mMaxImages = maxImages;
    }

    @Override
    public void onOutputSurface(@NonNull Surface surface, int imageFormat) {
        this.mPostCaptureProcessor.onOutputSurface(surface, imageFormat);
    }

    @Override
    public void process(@NonNull ImageProxyBundle bundle) {
        List<Integer> ids = bundle.getCaptureIds();
        ListenableFuture<ImageProxy> imageProxyListenableFuture = bundle.getImageProxy(ids.get(0));
        Preconditions.checkArgument((boolean)imageProxyListenableFuture.isDone());
        try {
            ImageInfo imageInfo;
            ImageProxy imageProxy = (ImageProxy)imageProxyListenableFuture.get();
            this.mSourceImageInfo = imageInfo = imageProxy.getImageInfo();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IllegalArgumentException("Can not successfully extract ImageProxy from the ImageProxyBundle.");
        }
        this.mPreCaptureProcessor.process(bundle);
    }

    @Override
    public void onResolutionUpdate(@NonNull Size size) {
        this.mIntermediateImageReader = new AndroidImageReaderProxy(ImageReader.newInstance((int)size.getWidth(), (int)size.getHeight(), (int)35, (int)this.mMaxImages));
        this.mPreCaptureProcessor.onOutputSurface(this.mIntermediateImageReader.getSurface(), 35);
        this.mPreCaptureProcessor.onResolutionUpdate(size);
        this.mPostCaptureProcessor.onResolutionUpdate(size);
        this.mIntermediateImageReader.setOnImageAvailableListener(new ImageReaderProxy.OnImageAvailableListener(){

            @Override
            public void onImageAvailable(@NonNull ImageReaderProxy imageReader) {
                CaptureProcessorPipeline.this.postProcess(imageReader.acquireNextImage());
            }
        }, this.mExecutor);
    }

    void postProcess(ImageProxy imageProxy) {
        Size resolution = new Size(imageProxy.getWidth(), imageProxy.getHeight());
        Preconditions.checkNotNull((Object)this.mSourceImageInfo);
        String tagBundleKey = this.mSourceImageInfo.getTagBundle().listKeys().iterator().next();
        int captureId = this.mSourceImageInfo.getTagBundle().getTag(tagBundleKey);
        SettableImageProxy settableImageProxy = new SettableImageProxy(imageProxy, resolution, this.mSourceImageInfo);
        this.mSourceImageInfo = null;
        SettableImageProxyBundle settableImageProxyBundle = new SettableImageProxyBundle(Collections.singletonList(captureId), tagBundleKey);
        settableImageProxyBundle.addImageProxy(settableImageProxy);
        this.mPostCaptureProcessor.process(settableImageProxyBundle);
    }

    void close() {
        if (this.mIntermediateImageReader != null) {
            this.mIntermediateImageReader.clearOnImageAvailableListener();
            this.mIntermediateImageReader.close();
        }
    }
}

