/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.core.Camera;
import androidx.camera.core.CameraControl;
import androidx.camera.core.CameraInfo;
import androidx.camera.core.UseCase;
import androidx.camera.core.impl.CameraConfig;
import androidx.camera.core.impl.CameraConfigs;
import androidx.camera.core.impl.CameraControlInternal;
import androidx.camera.core.impl.CameraInfoInternal;
import androidx.camera.core.impl.Observable;
import androidx.camera.core.internal.CameraUseCaseAdapter;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;

public interface CameraInternal
extends Camera,
UseCase.StateChangeCallback {
    public void open();

    public void close();

    @NonNull
    public ListenableFuture<Void> release();

    @NonNull
    public Observable<State> getCameraState();

    public void attachUseCases(@NonNull Collection<UseCase> var1);

    public void detachUseCases(@NonNull Collection<UseCase> var1);

    @NonNull
    public CameraControlInternal getCameraControlInternal();

    @NonNull
    public CameraInfoInternal getCameraInfoInternal();

    @Override
    @NonNull
    default public CameraControl getCameraControl() {
        return this.getCameraControlInternal();
    }

    @Override
    @NonNull
    default public CameraInfo getCameraInfo() {
        return this.getCameraInfoInternal();
    }

    @Override
    @NonNull
    default public LinkedHashSet<CameraInternal> getCameraInternals() {
        return new LinkedHashSet<CameraInternal>(Collections.singleton(this));
    }

    @Override
    @NonNull
    default public CameraConfig getExtendedConfig() {
        return CameraConfigs.emptyConfig();
    }

    @Override
    default public void setExtendedConfig(@Nullable CameraConfig cameraConfig) throws CameraUseCaseAdapter.CameraException {
    }

    public static enum State {
        PENDING_OPEN(false),
        OPENING(true),
        OPEN(true),
        CLOSING(true),
        CLOSED(false),
        RELEASING(true),
        RELEASED(false);

        private final boolean mHoldsCameraSlot;

        private State(boolean holdsCameraSlot) {
            this.mHoldsCameraSlot = holdsCameraSlot;
        }

        boolean holdsCameraSlot() {
            return this.mHoldsCameraSlot;
        }
    }
}

