/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.camera.core.ImageAnalysis;
import androidx.camera.core.ImageReaderProxyProvider;
import androidx.camera.core.impl.Config;
import androidx.camera.core.impl.ImageOutputConfig;
import androidx.camera.core.impl.OptionsBundle;
import androidx.camera.core.impl.UseCaseConfig;
import androidx.camera.core.internal.ThreadConfig;

public final class ImageAnalysisConfig
implements UseCaseConfig<ImageAnalysis>,
ImageOutputConfig,
ThreadConfig {
    public static final Config.Option<Integer> OPTION_BACKPRESSURE_STRATEGY = Config.Option.create("camerax.core.imageAnalysis.backpressureStrategy", ImageAnalysis.BackpressureStrategy.class);
    public static final Config.Option<Integer> OPTION_IMAGE_QUEUE_DEPTH = Config.Option.create("camerax.core.imageAnalysis.imageQueueDepth", Integer.TYPE);
    public static final Config.Option<ImageReaderProxyProvider> OPTION_IMAGE_READER_PROXY_PROVIDER = Config.Option.create("camerax.core.imageAnalysis.imageReaderProxyProvider", ImageReaderProxyProvider.class);
    private final OptionsBundle mConfig;

    public ImageAnalysisConfig(@NonNull OptionsBundle config) {
        this.mConfig = config;
    }

    @Override
    @NonNull
    public Config getConfig() {
        return this.mConfig;
    }

    public int getBackpressureStrategy(int valueIfMissing) {
        return this.retrieveOption(OPTION_BACKPRESSURE_STRATEGY, valueIfMissing);
    }

    public int getBackpressureStrategy() {
        return this.retrieveOption(OPTION_BACKPRESSURE_STRATEGY);
    }

    public int getImageQueueDepth(int valueIfMissing) {
        return this.retrieveOption(OPTION_IMAGE_QUEUE_DEPTH, valueIfMissing);
    }

    public int getImageQueueDepth() {
        return this.retrieveOption(OPTION_IMAGE_QUEUE_DEPTH);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public ImageReaderProxyProvider getImageReaderProxyProvider() {
        return this.retrieveOption(OPTION_IMAGE_READER_PROXY_PROVIDER, null);
    }

    @Override
    public int getInputFormat() {
        return 35;
    }
}

