/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl;

import androidx.annotation.NonNull;
import androidx.annotation.OptIn;
import androidx.camera.core.CameraFilter;
import androidx.camera.core.CameraInfo;
import androidx.camera.core.ExperimentalCameraFilter;
import androidx.camera.core.impl.CameraInfoInternal;
import androidx.core.util.Preconditions;
import java.util.ArrayList;
import java.util.List;

@OptIn(markerClass={ExperimentalCameraFilter.class})
public class LensFacingCameraFilter
implements CameraFilter {
    private int mLensFacing;

    public LensFacingCameraFilter(int lensFacing) {
        this.mLensFacing = lensFacing;
    }

    @Override
    @NonNull
    public List<CameraInfo> filter(@NonNull List<CameraInfo> cameraInfos) {
        ArrayList<CameraInfo> result = new ArrayList<CameraInfo>();
        for (CameraInfo cameraInfo : cameraInfos) {
            Preconditions.checkArgument((boolean)(cameraInfo instanceof CameraInfoInternal), (Object)"The camera info doesn't contain internal implementation.");
            Integer lensFacing = ((CameraInfoInternal)cameraInfo).getLensFacing();
            if (lensFacing == null || lensFacing != this.mLensFacing) continue;
            result.add(cameraInfo);
        }
        return result;
    }

    public int getLensFacing() {
        return this.mLensFacing;
    }
}

