/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.core.impl.Quirk;
import java.util.ArrayList;
import java.util.List;

public class Quirks {
    @NonNull
    private final List<Quirk> mQuirks;

    public Quirks(@NonNull List<Quirk> quirks) {
        this.mQuirks = new ArrayList<Quirk>(quirks);
    }

    @Nullable
    public <T extends Quirk> T get(@NonNull Class<T> quirkClass) {
        for (Quirk quirk : this.mQuirks) {
            if (quirk.getClass() != quirkClass) continue;
            return (T)quirk;
        }
        return null;
    }

    public boolean contains(@NonNull Class<? extends Quirk> quirkClass) {
        for (Quirk quirk : this.mQuirks) {
            if (!quirkClass.isAssignableFrom(quirk.getClass())) continue;
            return true;
        }
        return false;
    }
}

