/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl;

import androidx.annotation.NonNull;
import androidx.camera.core.Logger;
import androidx.camera.core.impl.SessionConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class UseCaseAttachState {
    private static final String TAG = "UseCaseAttachState";
    private final String mCameraId;
    private final Map<String, UseCaseAttachInfo> mAttachedUseCasesToInfoMap = new HashMap<String, UseCaseAttachInfo>();

    public UseCaseAttachState(@NonNull String cameraId) {
        this.mCameraId = cameraId;
    }

    public void setUseCaseActive(@NonNull String useCaseName, @NonNull SessionConfig sessionConfig) {
        UseCaseAttachInfo useCaseAttachInfo = this.getOrCreateUseCaseAttachInfo(useCaseName, sessionConfig);
        useCaseAttachInfo.setActive(true);
    }

    public void setUseCaseInactive(@NonNull String useCaseName) {
        if (!this.mAttachedUseCasesToInfoMap.containsKey(useCaseName)) {
            return;
        }
        UseCaseAttachInfo useCaseAttachInfo = this.mAttachedUseCasesToInfoMap.get(useCaseName);
        useCaseAttachInfo.setActive(false);
        if (!useCaseAttachInfo.getAttached()) {
            this.mAttachedUseCasesToInfoMap.remove(useCaseName);
        }
    }

    public void setUseCaseAttached(@NonNull String useCaseName, @NonNull SessionConfig sessionConfig) {
        UseCaseAttachInfo useCaseAttachInfo = this.getOrCreateUseCaseAttachInfo(useCaseName, sessionConfig);
        useCaseAttachInfo.setAttached(true);
    }

    public void setUseCaseDetached(@NonNull String useCaseName) {
        if (!this.mAttachedUseCasesToInfoMap.containsKey(useCaseName)) {
            return;
        }
        UseCaseAttachInfo useCaseAttachInfo = this.mAttachedUseCasesToInfoMap.get(useCaseName);
        useCaseAttachInfo.setAttached(false);
        if (!useCaseAttachInfo.getActive()) {
            this.mAttachedUseCasesToInfoMap.remove(useCaseName);
        }
    }

    public boolean isUseCaseAttached(@NonNull String useCaseName) {
        if (!this.mAttachedUseCasesToInfoMap.containsKey(useCaseName)) {
            return false;
        }
        UseCaseAttachInfo useCaseAttachInfo = this.mAttachedUseCasesToInfoMap.get(useCaseName);
        return useCaseAttachInfo.getAttached();
    }

    @NonNull
    public Collection<SessionConfig> getAttachedSessionConfigs() {
        return Collections.unmodifiableCollection(this.getSessionConfigs(useCaseAttachInfo -> useCaseAttachInfo.getAttached()));
    }

    @NonNull
    public Collection<SessionConfig> getActiveAndAttachedSessionConfigs() {
        return Collections.unmodifiableCollection(this.getSessionConfigs(useCaseAttachInfo -> useCaseAttachInfo.getActive() && useCaseAttachInfo.getAttached()));
    }

    public void updateUseCase(@NonNull String useCaseName, @NonNull SessionConfig sessionConfig) {
        if (!this.mAttachedUseCasesToInfoMap.containsKey(useCaseName)) {
            return;
        }
        UseCaseAttachInfo newUseCaseAttachInfo = new UseCaseAttachInfo(sessionConfig);
        UseCaseAttachInfo oldUseCaseAttachInfo = this.mAttachedUseCasesToInfoMap.get(useCaseName);
        newUseCaseAttachInfo.setAttached(oldUseCaseAttachInfo.getAttached());
        newUseCaseAttachInfo.setActive(oldUseCaseAttachInfo.getActive());
        this.mAttachedUseCasesToInfoMap.put(useCaseName, newUseCaseAttachInfo);
    }

    public void removeUseCase(@NonNull String useCaseName) {
        this.mAttachedUseCasesToInfoMap.remove(useCaseName);
    }

    @NonNull
    public SessionConfig.ValidatingBuilder getActiveAndAttachedBuilder() {
        SessionConfig.ValidatingBuilder validatingBuilder = new SessionConfig.ValidatingBuilder();
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry<String, UseCaseAttachInfo> attachedUseCase : this.mAttachedUseCasesToInfoMap.entrySet()) {
            UseCaseAttachInfo useCaseAttachInfo = attachedUseCase.getValue();
            if (!useCaseAttachInfo.getActive() || !useCaseAttachInfo.getAttached()) continue;
            String useCaseName = attachedUseCase.getKey();
            validatingBuilder.add(useCaseAttachInfo.getSessionConfig());
            list.add(useCaseName);
        }
        Logger.d(TAG, "Active and attached use case: " + list + " for camera: " + this.mCameraId);
        return validatingBuilder;
    }

    @NonNull
    public SessionConfig.ValidatingBuilder getAttachedBuilder() {
        SessionConfig.ValidatingBuilder validatingBuilder = new SessionConfig.ValidatingBuilder();
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry<String, UseCaseAttachInfo> attachedUseCase : this.mAttachedUseCasesToInfoMap.entrySet()) {
            UseCaseAttachInfo useCaseAttachInfo = attachedUseCase.getValue();
            if (!useCaseAttachInfo.getAttached()) continue;
            validatingBuilder.add(useCaseAttachInfo.getSessionConfig());
            String useCaseName = attachedUseCase.getKey();
            list.add(useCaseName);
        }
        Logger.d(TAG, "All use case: " + list + " for camera: " + this.mCameraId);
        return validatingBuilder;
    }

    private UseCaseAttachInfo getOrCreateUseCaseAttachInfo(@NonNull String useCaseName, @NonNull SessionConfig sessionConfig) {
        UseCaseAttachInfo useCaseAttachInfo = this.mAttachedUseCasesToInfoMap.get(useCaseName);
        if (useCaseAttachInfo == null) {
            useCaseAttachInfo = new UseCaseAttachInfo(sessionConfig);
            this.mAttachedUseCasesToInfoMap.put(useCaseName, useCaseAttachInfo);
        }
        return useCaseAttachInfo;
    }

    private Collection<SessionConfig> getSessionConfigs(AttachStateFilter attachStateFilter) {
        ArrayList<SessionConfig> sessionConfigs = new ArrayList<SessionConfig>();
        for (Map.Entry<String, UseCaseAttachInfo> attachedUseCase : this.mAttachedUseCasesToInfoMap.entrySet()) {
            if (attachStateFilter != null && !attachStateFilter.filter(attachedUseCase.getValue())) continue;
            sessionConfigs.add(attachedUseCase.getValue().getSessionConfig());
        }
        return sessionConfigs;
    }

    private static final class UseCaseAttachInfo {
        @NonNull
        private final SessionConfig mSessionConfig;
        private boolean mAttached = false;
        private boolean mActive = false;

        UseCaseAttachInfo(@NonNull SessionConfig sessionConfig) {
            this.mSessionConfig = sessionConfig;
        }

        @NonNull
        SessionConfig getSessionConfig() {
            return this.mSessionConfig;
        }

        boolean getAttached() {
            return this.mAttached;
        }

        void setAttached(boolean attached) {
            this.mAttached = attached;
        }

        boolean getActive() {
            return this.mActive;
        }

        void setActive(boolean active) {
            this.mActive = active;
        }
    }

    private static interface AttachStateFilter {
        public boolean filter(UseCaseAttachInfo var1);
    }
}

