/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl.utils.executor;

import androidx.annotation.NonNull;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

final class HighPriorityExecutor
implements Executor {
    private static volatile Executor sExecutor;
    private final ExecutorService mHighPriorityService = Executors.newSingleThreadExecutor(new ThreadFactory(){
        private static final String THREAD_NAME = "CameraX-camerax_high_priority";

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r);
            t.setPriority(10);
            t.setName(THREAD_NAME);
            return t;
        }
    });

    HighPriorityExecutor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Executor getInstance() {
        if (sExecutor != null) {
            return sExecutor;
        }
        Class<HighPriorityExecutor> clazz = HighPriorityExecutor.class;
        synchronized (HighPriorityExecutor.class) {
            if (sExecutor == null) {
                sExecutor = new HighPriorityExecutor();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sExecutor;
        }
    }

    @Override
    public void execute(@NonNull Runnable command) {
        this.mHighPriorityService.execute(command);
    }
}

