/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.internal;

import android.graphics.Rect;
import android.graphics.YuvImage;
import android.media.Image;
import android.media.ImageWriter;
import android.util.Size;
import android.view.Surface;
import androidx.annotation.GuardedBy;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.camera.core.ImageProxy;
import androidx.camera.core.Logger;
import androidx.camera.core.impl.CaptureProcessor;
import androidx.camera.core.impl.ImageProxyBundle;
import androidx.camera.core.impl.utils.ExifData;
import androidx.camera.core.impl.utils.ExifOutputStream;
import androidx.camera.core.internal.compat.ImageWriterCompat;
import androidx.camera.core.internal.utils.ImageUtil;
import androidx.core.util.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.ExecutionException;

@RequiresApi(value=26)
public class YuvToJpegProcessor
implements CaptureProcessor {
    private static final String TAG = "YuvToJpegProcessor";
    private static final Rect UNINITIALIZED_RECT = new Rect(0, 0, 0, 0);
    @IntRange(from=0L, to=100L)
    private final int mQuality;
    private final int mMaxImages;
    private final Object mLock = new Object();
    @GuardedBy(value="mLock")
    private boolean mClosed = false;
    @GuardedBy(value="mLock")
    private int mProcessingImages = 0;
    @GuardedBy(value="mLock")
    private ImageWriter mImageWriter;
    @GuardedBy(value="mLock")
    private Rect mImageRect = UNINITIALIZED_RECT;

    public YuvToJpegProcessor(@IntRange(from=0L, to=100L) int quality, int maxImages) {
        this.mQuality = quality;
        this.mMaxImages = maxImages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onOutputSurface(@NonNull Surface surface, int imageFormat) {
        Preconditions.checkState((imageFormat == 256 ? 1 : 0) != 0, (String)"YuvToJpegProcessor only supports JPEG output format.");
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mClosed) {
                if (this.mImageWriter != null) {
                    throw new IllegalStateException("Output surface already set.");
                }
                this.mImageWriter = ImageWriterCompat.newInstance(surface, this.mMaxImages, imageFormat);
            } else {
                Logger.w(TAG, "Cannot set output surface. Processor is closed.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void process(@NonNull ImageProxyBundle bundle) {
        boolean shouldCloseImageWriter;
        Object object;
        Image jpegImage;
        ImageProxy imageProxy;
        Rect imageRect;
        boolean processing;
        ImageWriter imageWriter;
        ListenableFuture<ImageProxy> imageProxyListenableFuture;
        block30: {
            boolean shouldCloseImageWriter2;
            List<Integer> ids = bundle.getCaptureIds();
            Preconditions.checkArgument((ids.size() == 1 ? 1 : 0) != 0, (Object)("Processing image bundle have single capture id, but found " + ids.size()));
            imageProxyListenableFuture = bundle.getImageProxy(ids.get(0));
            Preconditions.checkArgument((boolean)imageProxyListenableFuture.isDone());
            Object object2 = this.mLock;
            synchronized (object2) {
                imageWriter = this.mImageWriter;
                processing = !this.mClosed;
                imageRect = this.mImageRect;
                if (processing) {
                    ++this.mProcessingImages;
                }
            }
            imageProxy = null;
            jpegImage = null;
            imageProxy = (ImageProxy)imageProxyListenableFuture.get();
            if (processing) break block30;
            Logger.w(TAG, "Image enqueued for processing on closed processor.");
            imageProxy.close();
            imageProxy = null;
            Object object3 = this.mLock;
            synchronized (object3) {
                shouldCloseImageWriter2 = processing && this.mProcessingImages-- == 0 && this.mClosed;
            }
            if (jpegImage != null) {
                jpegImage.close();
            }
            if (imageProxy != null) {
                imageProxy.close();
            }
            if (!shouldCloseImageWriter2) return;
            imageWriter.close();
            Logger.d(TAG, "Closed after completion of last image processed.");
            return;
        }
        try {
            jpegImage = imageWriter.dequeueInputImage();
            imageProxy = (ImageProxy)imageProxyListenableFuture.get();
            Preconditions.checkState((imageProxy.getFormat() == 35 ? 1 : 0) != 0, (String)"Input image is not expected YUV_420_888 image format");
            byte[] yuvBytes = ImageUtil.yuv_420_888toNv21(imageProxy);
            YuvImage yuvImage = new YuvImage(yuvBytes, 17, imageProxy.getWidth(), imageProxy.getHeight(), null);
            ByteBuffer jpegBuf = jpegImage.getPlanes()[0].getBuffer();
            int initialPos = jpegBuf.position();
            ExifOutputStream os = new ExifOutputStream(new ByteBufferOutputStream(jpegBuf), YuvToJpegProcessor.getExifData(imageProxy));
            yuvImage.compressToJpeg(imageRect, this.mQuality, (OutputStream)os);
            imageProxy.close();
            imageProxy = null;
            jpegBuf.limit(jpegBuf.position());
            jpegBuf.position(initialPos);
            imageWriter.queueInputImage(jpegImage);
            jpegImage = null;
            object = this.mLock;
        }
        catch (InterruptedException | ExecutionException e) {
            boolean shouldCloseImageWriter3;
            Object object4;
            try {
                if (processing) {
                    Logger.e(TAG, "Failed to process YUV -> JPEG", e);
                    jpegImage = imageWriter.dequeueInputImage();
                    ByteBuffer byteBuffer = jpegImage.getPlanes()[0].getBuffer();
                    byteBuffer.rewind();
                    byteBuffer.limit(0);
                    imageWriter.queueInputImage(jpegImage);
                }
                object4 = this.mLock;
            }
            catch (Throwable throwable) {
                boolean shouldCloseImageWriter4;
                Object object5 = this.mLock;
                synchronized (object5) {
                    shouldCloseImageWriter4 = processing && this.mProcessingImages-- == 0 && this.mClosed;
                }
                if (jpegImage != null) {
                    jpegImage.close();
                }
                if (imageProxy != null) {
                    imageProxy.close();
                }
                if (!shouldCloseImageWriter4) throw throwable;
                imageWriter.close();
                Logger.d(TAG, "Closed after completion of last image processed.");
                throw throwable;
            }
            synchronized (object4) {
                shouldCloseImageWriter3 = processing && this.mProcessingImages-- == 0 && this.mClosed;
            }
            if (jpegImage != null) {
                jpegImage.close();
            }
            if (imageProxy != null) {
                imageProxy.close();
            }
            if (!shouldCloseImageWriter3) return;
            imageWriter.close();
            Logger.d(TAG, "Closed after completion of last image processed.");
            return;
        }
        synchronized (object) {
            shouldCloseImageWriter = processing && this.mProcessingImages-- == 0 && this.mClosed;
        }
        if (jpegImage != null) {
            jpegImage.close();
        }
        if (imageProxy != null) {
            imageProxy.close();
        }
        if (!shouldCloseImageWriter) return;
        imageWriter.close();
        Logger.d(TAG, "Closed after completion of last image processed.");
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mClosed) {
                this.mClosed = true;
                if (this.mProcessingImages == 0 && this.mImageWriter != null) {
                    Logger.d(TAG, "No processing in progress. Closing immediately.");
                    this.mImageWriter.close();
                } else {
                    Logger.d(TAG, "close() called while processing. Will close after completion.");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onResolutionUpdate(@NonNull Size size) {
        Object object = this.mLock;
        synchronized (object) {
            this.mImageRect = new Rect(0, 0, size.getWidth(), size.getHeight());
        }
    }

    @NonNull
    private static ExifData getExifData(@NonNull ImageProxy imageProxy) {
        ExifData.Builder builder = ExifData.builderForDevice();
        imageProxy.getImageInfo().populateExifData(builder);
        return builder.setImageWidth(imageProxy.getWidth()).setImageHeight(imageProxy.getHeight()).build();
    }

    private static final class ByteBufferOutputStream
    extends OutputStream {
        private final ByteBuffer mByteBuffer;

        ByteBufferOutputStream(@NonNull ByteBuffer buf) {
            this.mByteBuffer = buf;
        }

        @Override
        public void write(int b) throws IOException {
            if (!this.mByteBuffer.hasRemaining()) {
                throw new EOFException("Output ByteBuffer has no bytes remaining.");
            }
            this.mByteBuffer.put((byte)b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return;
            }
            if (this.mByteBuffer.remaining() < len) {
                throw new EOFException("Output ByteBuffer has insufficient bytes remaining.");
            }
            this.mByteBuffer.put(b, off, len);
        }
    }
}

