/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.camera.core.CameraSelector;
import androidx.camera.core.CameraState;
import androidx.camera.core.ExposureState;
import androidx.camera.core.FocusMeteringAction;
import androidx.camera.core.ZoomState;
import androidx.lifecycle.LiveData;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

@RequiresApi(value=21)
public interface CameraInfo {
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    public static final String IMPLEMENTATION_TYPE_UNKNOWN = "<unknown>";
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    public static final String IMPLEMENTATION_TYPE_CAMERA2 = "androidx.camera.camera2";
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    public static final String IMPLEMENTATION_TYPE_CAMERA2_LEGACY = "androidx.camera.camera2.legacy";
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    public static final String IMPLEMENTATION_TYPE_FAKE = "androidx.camera.fake";

    public int getSensorRotationDegrees();

    public int getSensorRotationDegrees(int var1);

    public boolean hasFlashUnit();

    @NonNull
    public LiveData<Integer> getTorchState();

    @NonNull
    public LiveData<ZoomState> getZoomState();

    @NonNull
    public ExposureState getExposureState();

    @NonNull
    public LiveData<CameraState> getCameraState();

    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public String getImplementationType();

    @NonNull
    public CameraSelector getCameraSelector();

    default public boolean isFocusMeteringSupported(@NonNull FocusMeteringAction action) {
        return false;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    default public boolean isYuvReprocessingSupported() {
        return false;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    default public boolean isPrivateReprocessingSupported() {
        return false;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface ImplementationType {
    }
}

