/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.camera.core.ImageAnalysisAbstractAnalyzer;
import androidx.camera.core.ImageProxy;
import androidx.camera.core.impl.ImageReaderProxy;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.camera.core.impl.utils.futures.FutureCallback;
import androidx.camera.core.impl.utils.futures.Futures;
import com.google.common.util.concurrent.ListenableFuture;

@RequiresApi(value=21)
final class ImageAnalysisBlockingAnalyzer
extends ImageAnalysisAbstractAnalyzer {
    ImageAnalysisBlockingAnalyzer() {
    }

    @Override
    @Nullable
    ImageProxy acquireImage(@NonNull ImageReaderProxy imageReaderProxy) {
        return imageReaderProxy.acquireNextImage();
    }

    @Override
    void onValidImageAvailable(final @NonNull ImageProxy imageProxy) {
        ListenableFuture<Void> analyzeFuture = this.analyzeImage(imageProxy);
        Futures.addCallback(analyzeFuture, new FutureCallback<Void>(){

            @Override
            public void onSuccess(Void result) {
            }

            @Override
            public void onFailure(Throwable t) {
                imageProxy.close();
            }
        }, CameraXExecutors.directExecutor());
    }

    @Override
    void clearCache() {
    }
}

