/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import android.graphics.Rect;
import android.util.Size;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.camera.core.ForwardingImageProxy;
import androidx.camera.core.ImageInfo;
import androidx.camera.core.ImageProxy;

@RequiresApi(value=21)
final class SettableImageProxy
extends ForwardingImageProxy {
    private final ImageInfo mImageInfo;
    @Nullable
    private Rect mCropRect;
    private final int mWidth;
    private final int mHeight;

    SettableImageProxy(ImageProxy imageProxy, ImageInfo imageInfo) {
        this(imageProxy, null, imageInfo);
    }

    SettableImageProxy(ImageProxy imageProxy, @Nullable Size resolution, ImageInfo imageInfo) {
        super(imageProxy);
        if (resolution == null) {
            this.mWidth = super.getWidth();
            this.mHeight = super.getHeight();
        } else {
            this.mWidth = resolution.getWidth();
            this.mHeight = resolution.getHeight();
        }
        this.mImageInfo = imageInfo;
    }

    @Override
    @NonNull
    public synchronized Rect getCropRect() {
        if (this.mCropRect == null) {
            return new Rect(0, 0, this.getWidth(), this.getHeight());
        }
        return new Rect(this.mCropRect);
    }

    @Override
    public synchronized void setCropRect(@Nullable Rect cropRect) {
        if (cropRect != null && !(cropRect = new Rect(cropRect)).intersect(0, 0, this.getWidth(), this.getHeight())) {
            cropRect.setEmpty();
        }
        this.mCropRect = cropRect;
    }

    @Override
    public synchronized int getWidth() {
        return this.mWidth;
    }

    @Override
    public synchronized int getHeight() {
        return this.mHeight;
    }

    @Override
    @NonNull
    public ImageInfo getImageInfo() {
        return this.mImageInfo;
    }
}

