/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.camera.core.UseCase;
import androidx.camera.core.ViewPort;
import androidx.core.util.Preconditions;
import java.util.ArrayList;
import java.util.List;

@RequiresApi(value=21)
public final class UseCaseGroup {
    @Nullable
    private final ViewPort mViewPort;
    @NonNull
    private final List<UseCase> mUseCases;

    UseCaseGroup(@Nullable ViewPort viewPort, @NonNull List<UseCase> useCases) {
        this.mViewPort = viewPort;
        this.mUseCases = useCases;
    }

    @Nullable
    public ViewPort getViewPort() {
        return this.mViewPort;
    }

    @NonNull
    public List<UseCase> getUseCases() {
        return this.mUseCases;
    }

    public static final class Builder {
        private ViewPort mViewPort;
        private final List<UseCase> mUseCases = new ArrayList<UseCase>();

        @NonNull
        public Builder setViewPort(@NonNull ViewPort viewPort) {
            this.mViewPort = viewPort;
            return this;
        }

        @NonNull
        public Builder addUseCase(@NonNull UseCase useCase) {
            this.mUseCases.add(useCase);
            return this;
        }

        @NonNull
        public UseCaseGroup build() {
            Preconditions.checkArgument((!this.mUseCases.isEmpty() ? 1 : 0) != 0, (Object)"UseCase must not be empty.");
            return new UseCaseGroup(this.mViewPort, this.mUseCases);
        }
    }
}

