/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.imagecapture;

import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.camera.core.ImageCaptureException;
import androidx.camera.core.imagecapture.TakePictureCallback;
import androidx.camera.core.impl.CaptureConfig;
import androidx.camera.core.impl.utils.Threads;
import java.util.List;

@RequiresApi(api=21)
public final class CameraRequest {
    private final List<CaptureConfig> mCaptureConfigs;
    private final TakePictureCallback mCallback;

    public CameraRequest(@NonNull List<CaptureConfig> captureConfigs, @NonNull TakePictureCallback callback) {
        this.mCaptureConfigs = captureConfigs;
        this.mCallback = callback;
    }

    @NonNull
    List<CaptureConfig> getCaptureConfigs() {
        return this.mCaptureConfigs;
    }

    @MainThread
    void onCaptureFailure(@NonNull ImageCaptureException imageCaptureException) {
        Threads.checkMainThread();
        this.mCallback.onCaptureFailure(imageCaptureException);
    }
}

