/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.imagecapture;

import android.util.Size;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import androidx.camera.core.CaptureBundles;
import androidx.camera.core.ForwardingImageProxy;
import androidx.camera.core.imagecapture.CameraRequest;
import androidx.camera.core.imagecapture.CaptureNode;
import androidx.camera.core.imagecapture.ProcessingNode;
import androidx.camera.core.imagecapture.ProcessingRequest;
import androidx.camera.core.imagecapture.SingleBundlingNode;
import androidx.camera.core.imagecapture.TakePictureCallback;
import androidx.camera.core.imagecapture.TakePictureRequest;
import androidx.camera.core.impl.CaptureBundle;
import androidx.camera.core.impl.CaptureConfig;
import androidx.camera.core.impl.CaptureStage;
import androidx.camera.core.impl.ImageCaptureConfig;
import androidx.camera.core.impl.SessionConfig;
import androidx.camera.core.impl.utils.Threads;
import androidx.camera.core.impl.utils.TransformUtils;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.camera.core.internal.compat.workaround.ExifRotationAvailability;
import androidx.core.util.Pair;
import java.util.ArrayList;
import java.util.Objects;

@RequiresApi(api=21)
public class ImagePipeline {
    static final byte JPEG_QUALITY_MAX_QUALITY = 100;
    static final byte JPEG_QUALITY_MIN_LATENCY = 95;
    static final ExifRotationAvailability EXIF_ROTATION_AVAILABILITY = new ExifRotationAvailability();
    @NonNull
    private final ImageCaptureConfig mUseCaseConfig;
    @NonNull
    private final CaptureConfig mCaptureConfig;
    @NonNull
    private final CaptureNode mCaptureNode;
    @NonNull
    private final SingleBundlingNode mBundlingNode;
    @NonNull
    private final ProcessingNode mProcessingNode;
    @NonNull
    private final CaptureNode.In mPipelineIn;

    @MainThread
    public ImagePipeline(@NonNull ImageCaptureConfig useCaseConfig, @NonNull Size cameraSurfaceSize) {
        Threads.checkMainThread();
        this.mUseCaseConfig = useCaseConfig;
        this.mCaptureConfig = CaptureConfig.Builder.createFrom(useCaseConfig).build();
        this.mCaptureNode = new CaptureNode();
        this.mBundlingNode = new SingleBundlingNode();
        this.mProcessingNode = new ProcessingNode(Objects.requireNonNull(this.mUseCaseConfig.getIoExecutor(CameraXExecutors.ioExecutor())));
        this.mPipelineIn = CaptureNode.In.of(cameraSurfaceSize, this.mUseCaseConfig.getInputFormat());
        CaptureNode.Out captureOut = this.mCaptureNode.transform(this.mPipelineIn);
        ProcessingNode.In processingIn = this.mBundlingNode.transform(captureOut);
        this.mProcessingNode.transform(processingIn);
    }

    @NonNull
    public SessionConfig.Builder createSessionConfigBuilder() {
        SessionConfig.Builder builder = SessionConfig.Builder.createFrom(this.mUseCaseConfig);
        builder.addNonRepeatingSurface(this.mPipelineIn.getSurface());
        return builder;
    }

    @MainThread
    public void close() {
        Threads.checkMainThread();
        this.mCaptureNode.release();
        this.mBundlingNode.release();
        this.mProcessingNode.release();
    }

    @MainThread
    public int getCapacity() {
        Threads.checkMainThread();
        return this.mCaptureNode.getCapacity();
    }

    @MainThread
    public void setOnImageCloseListener(@NonNull ForwardingImageProxy.OnImageCloseListener listener) {
        Threads.checkMainThread();
        this.mCaptureNode.setOnImageCloseListener(listener);
    }

    @MainThread
    @NonNull
    Pair<CameraRequest, ProcessingRequest> createRequests(@NonNull TakePictureRequest takePictureRequest, @NonNull TakePictureCallback takePictureCallback) {
        Threads.checkMainThread();
        CaptureBundle captureBundle = this.createCaptureBundle();
        return new Pair((Object)this.createCameraRequest(captureBundle, takePictureRequest, takePictureCallback), (Object)this.createProcessingRequest(captureBundle, takePictureRequest, takePictureCallback));
    }

    @MainThread
    void postProcess(@NonNull ProcessingRequest request) {
        Threads.checkMainThread();
        this.mPipelineIn.getRequestEdge().accept(request);
    }

    @NonNull
    private CaptureBundle createCaptureBundle() {
        return Objects.requireNonNull(this.mUseCaseConfig.getCaptureBundle(CaptureBundles.singleDefaultCaptureBundle()));
    }

    @NonNull
    private ProcessingRequest createProcessingRequest(@NonNull CaptureBundle captureBundle, @NonNull TakePictureRequest takePictureRequest, @NonNull TakePictureCallback takePictureCallback) {
        return new ProcessingRequest(captureBundle, takePictureRequest.getOutputFileOptions(), takePictureRequest.getCropRect(), takePictureRequest.getRotationDegrees(), takePictureRequest.getJpegQuality(), takePictureRequest.getSensorToBufferTransform(), takePictureCallback);
    }

    private CameraRequest createCameraRequest(@NonNull CaptureBundle captureBundle, @NonNull TakePictureRequest takePictureRequest, @NonNull TakePictureCallback takePictureCallback) {
        ArrayList<CaptureConfig> captureConfigs = new ArrayList<CaptureConfig>();
        String tagBundleKey = String.valueOf(captureBundle.hashCode());
        for (CaptureStage captureStage : Objects.requireNonNull(captureBundle.getCaptureStages())) {
            CaptureConfig.Builder builder = new CaptureConfig.Builder();
            builder.setTemplateType(this.mCaptureConfig.getTemplateType());
            builder.addImplementationOptions(this.mCaptureConfig.getImplementationOptions());
            builder.addAllCameraCaptureCallbacks(takePictureRequest.getSessionConfigCameraCaptureCallbacks());
            builder.addSurface(this.mPipelineIn.getSurface());
            if (this.mPipelineIn.getFormat() == 256) {
                if (EXIF_ROTATION_AVAILABILITY.isRotationOptionSupported()) {
                    builder.addImplementationOption(CaptureConfig.OPTION_ROTATION, takePictureRequest.getRotationDegrees());
                }
                builder.addImplementationOption(CaptureConfig.OPTION_JPEG_QUALITY, this.getCameraRequestJpegQuality(takePictureRequest));
            }
            builder.addImplementationOptions(captureStage.getCaptureConfig().getImplementationOptions());
            builder.addTag(tagBundleKey, captureStage.getId());
            builder.addCameraCaptureCallback(this.mPipelineIn.getCameraCaptureCallback());
            captureConfigs.add(builder.build());
        }
        return new CameraRequest(captureConfigs, takePictureCallback);
    }

    int getCameraRequestJpegQuality(@NonNull TakePictureRequest request) {
        boolean isOnDisk = request.getOnDiskCallback() != null;
        boolean hasCropping = TransformUtils.hasCropping(request.getCropRect(), this.mPipelineIn.getSize());
        if (isOnDisk && hasCropping) {
            if (request.getCaptureMode() == 0) {
                return 100;
            }
            return 95;
        }
        return request.getJpegQuality();
    }

    @NonNull
    @VisibleForTesting
    CaptureNode getCaptureNode() {
        return this.mCaptureNode;
    }
}

