/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.imagecapture;

import android.graphics.Bitmap;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import androidx.camera.core.ImageCapture;
import androidx.camera.core.ImageCaptureException;
import androidx.camera.core.ImageProxy;
import androidx.camera.core.imagecapture.AutoValue_ProcessingNode_In;
import androidx.camera.core.imagecapture.AutoValue_ProcessingNode_InputPacket;
import androidx.camera.core.imagecapture.Bitmap2JpegBytes;
import androidx.camera.core.imagecapture.Image2JpegBytes;
import androidx.camera.core.imagecapture.JpegBytes2CroppedBitmap;
import androidx.camera.core.imagecapture.JpegBytes2Disk;
import androidx.camera.core.imagecapture.JpegBytes2Image;
import androidx.camera.core.imagecapture.JpegImage2Result;
import androidx.camera.core.imagecapture.ProcessingInput2Packet;
import androidx.camera.core.imagecapture.ProcessingRequest;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.camera.core.processing.Edge;
import androidx.camera.core.processing.Node;
import androidx.camera.core.processing.Operation;
import androidx.camera.core.processing.Packet;
import androidx.core.util.Consumer;
import com.google.auto.value.AutoValue;
import java.util.Objects;
import java.util.concurrent.Executor;

@RequiresApi(api=21)
public class ProcessingNode
implements Node<In, Void> {
    @NonNull
    private final Executor mBlockingExecutor;
    private Operation<InputPacket, Packet<ImageProxy>> mInput2Packet;
    private Operation<Image2JpegBytes.In, Packet<byte[]>> mImage2JpegBytes;
    private Operation<Bitmap2JpegBytes.In, Packet<byte[]>> mBitmap2JpegBytes;
    private Operation<JpegBytes2Disk.In, ImageCapture.OutputFileResults> mJpegBytes2Disk;
    private Operation<Packet<byte[]>, Packet<Bitmap>> mJpegBytes2CroppedBitmap;
    private Operation<Packet<ImageProxy>, ImageProxy> mJpegImage2Result;
    private Operation<Packet<byte[]>, Packet<ImageProxy>> mJpegBytes2Image;

    ProcessingNode(@NonNull Executor blockingExecutor) {
        this.mBlockingExecutor = blockingExecutor;
    }

    @Override
    @NonNull
    public Void transform(@NonNull In inputEdge) {
        inputEdge.getEdge().setListener((Consumer<InputPacket>)((Consumer)inputPacket -> {
            if (inputPacket.getProcessingRequest().isAborted()) {
                return;
            }
            this.mBlockingExecutor.execute(() -> this.processInputPacket((InputPacket)inputPacket));
        }));
        this.mInput2Packet = new ProcessingInput2Packet();
        this.mImage2JpegBytes = new Image2JpegBytes();
        this.mJpegBytes2CroppedBitmap = new JpegBytes2CroppedBitmap();
        this.mBitmap2JpegBytes = new Bitmap2JpegBytes();
        this.mJpegBytes2Disk = new JpegBytes2Disk();
        this.mJpegImage2Result = new JpegImage2Result();
        if (inputEdge.getFormat() == 35) {
            this.mJpegBytes2Image = new JpegBytes2Image();
        }
        return null;
    }

    @Override
    public void release() {
    }

    @WorkerThread
    void processInputPacket(@NonNull InputPacket inputPacket) {
        ProcessingRequest request = inputPacket.getProcessingRequest();
        try {
            if (inputPacket.getProcessingRequest().isInMemoryCapture()) {
                ImageProxy result = this.processInMemoryCapture(inputPacket);
                CameraXExecutors.mainThreadExecutor().execute(() -> request.onFinalResult(result));
            } else {
                ImageCapture.OutputFileResults result = this.processOnDiskCapture(inputPacket);
                CameraXExecutors.mainThreadExecutor().execute(() -> request.onFinalResult(result));
            }
        }
        catch (ImageCaptureException e) {
            ProcessingNode.sendError(request, e);
        }
        catch (RuntimeException e) {
            ProcessingNode.sendError(request, new ImageCaptureException(0, "Processing failed.", e));
        }
    }

    @NonNull
    @WorkerThread
    ImageCapture.OutputFileResults processOnDiskCapture(@NonNull InputPacket inputPacket) throws ImageCaptureException {
        ProcessingRequest request = inputPacket.getProcessingRequest();
        Packet<ImageProxy> originalImage = this.mInput2Packet.apply(inputPacket);
        Packet<byte[]> jpegBytes = this.mImage2JpegBytes.apply(Image2JpegBytes.In.of(originalImage, request.getJpegQuality()));
        if (jpegBytes.hasCropping()) {
            Packet<Bitmap> croppedBitmap = this.mJpegBytes2CroppedBitmap.apply(jpegBytes);
            jpegBytes = this.mBitmap2JpegBytes.apply(Bitmap2JpegBytes.In.of(croppedBitmap, request.getJpegQuality()));
        }
        return this.mJpegBytes2Disk.apply(JpegBytes2Disk.In.of(jpegBytes, Objects.requireNonNull(request.getOutputFileOptions())));
    }

    @NonNull
    @WorkerThread
    ImageProxy processInMemoryCapture(@NonNull InputPacket inputPacket) throws ImageCaptureException {
        ProcessingRequest request = inputPacket.getProcessingRequest();
        Packet<ImageProxy> image = this.mInput2Packet.apply(inputPacket);
        if (image.getFormat() == 35) {
            Packet<byte[]> jpegPacket = this.mImage2JpegBytes.apply(Image2JpegBytes.In.of(image, request.getJpegQuality()));
            image = this.mJpegBytes2Image.apply(jpegPacket);
        }
        return this.mJpegImage2Result.apply(image);
    }

    private static void sendError(@NonNull ProcessingRequest request, @NonNull ImageCaptureException e) {
        CameraXExecutors.mainThreadExecutor().execute(() -> request.onProcessFailure(e));
    }

    @VisibleForTesting
    void injectJpegBytes2CroppedBitmapForTesting(@NonNull Operation<Packet<byte[]>, Packet<Bitmap>> operation) {
        this.mJpegBytes2CroppedBitmap = operation;
    }

    @AutoValue
    static abstract class In {
        In() {
        }

        abstract Edge<InputPacket> getEdge();

        abstract int getFormat();

        static In of(int format) {
            return new AutoValue_ProcessingNode_In(new Edge<InputPacket>(), format);
        }
    }

    @AutoValue
    static abstract class InputPacket {
        InputPacket() {
        }

        @NonNull
        abstract ProcessingRequest getProcessingRequest();

        @NonNull
        abstract ImageProxy getImageProxy();

        static InputPacket of(@NonNull ProcessingRequest processingRequest, @NonNull ImageProxy imageProxy) {
            return new AutoValue_ProcessingNode_InputPacket(processingRequest, imageProxy);
        }
    }
}

