/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl;

import android.media.CamcorderProfile;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.camera.core.impl.AutoValue_CamcorderProfileProxy;
import com.google.auto.value.AutoValue;

@RequiresApi(value=21)
@AutoValue
public abstract class CamcorderProfileProxy {
    public static int CODEC_PROFILE_NONE = -1;

    @NonNull
    public static CamcorderProfileProxy create(int duration, int quality, int fileFormat, int videoCodec, int videoBitRate, int videoFrameRate, int videoFrameWidth, int videoFrameHeight, int audioCodec, int audioBitRate, int audioSampleRate, int audioChannels) {
        return new AutoValue_CamcorderProfileProxy(duration, quality, fileFormat, videoCodec, videoBitRate, videoFrameRate, videoFrameWidth, videoFrameHeight, audioCodec, audioBitRate, audioSampleRate, audioChannels);
    }

    @NonNull
    public static CamcorderProfileProxy fromCamcorderProfile(@NonNull CamcorderProfile camcorderProfile) {
        return new AutoValue_CamcorderProfileProxy(camcorderProfile.duration, camcorderProfile.quality, camcorderProfile.fileFormat, camcorderProfile.videoCodec, camcorderProfile.videoBitRate, camcorderProfile.videoFrameRate, camcorderProfile.videoFrameWidth, camcorderProfile.videoFrameHeight, camcorderProfile.audioCodec, camcorderProfile.audioBitRate, camcorderProfile.audioSampleRate, camcorderProfile.audioChannels);
    }

    public abstract int getDuration();

    public abstract int getQuality();

    public abstract int getFileFormat();

    public abstract int getVideoCodec();

    public abstract int getVideoBitRate();

    public abstract int getVideoFrameRate();

    public abstract int getVideoFrameWidth();

    public abstract int getVideoFrameHeight();

    public abstract int getAudioCodec();

    public abstract int getAudioBitRate();

    public abstract int getAudioSampleRate();

    public abstract int getAudioChannels();

    @Nullable
    public String getVideoCodecMimeType() {
        switch (this.getVideoCodec()) {
            case 1: {
                return "video/3gpp";
            }
            case 2: {
                return "video/avc";
            }
            case 5: {
                return "video/hevc";
            }
            case 4: {
                return "video/x-vnd.on2.vp8";
            }
            case 3: {
                return "video/mp4v-es";
            }
        }
        return null;
    }

    @Nullable
    public String getAudioCodecMimeType() {
        switch (this.getAudioCodec()) {
            case 3: 
            case 4: 
            case 5: {
                return "audio/mp4a-latm";
            }
            case 1: {
                return "audio/3gpp";
            }
            case 2: {
                return "audio/amr-wb";
            }
            case 7: {
                return "audio/opus";
            }
            case 6: {
                return "audio/vorbis";
            }
        }
        return null;
    }

    public int getRequiredAudioProfile() {
        switch (this.getAudioCodec()) {
            case 3: {
                return 2;
            }
            case 5: {
                return 39;
            }
            case 4: {
                return 5;
            }
        }
        return CODEC_PROFILE_NONE;
    }
}

