/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.processing;

import android.graphics.Rect;
import android.graphics.RectF;
import android.opengl.Matrix;
import android.util.Size;
import android.view.Surface;
import androidx.annotation.AnyThread;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.camera.core.Logger;
import androidx.camera.core.SurfaceOutput;
import androidx.camera.core.impl.utils.MatrixExt;
import androidx.camera.core.impl.utils.TransformUtils;
import androidx.concurrent.futures.CallbackToFutureAdapter;
import androidx.core.util.Consumer;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicReference;

@RequiresApi(value=21)
final class SurfaceOutputImpl
implements SurfaceOutput {
    private static final String TAG = "SurfaceOutputImpl";
    private final Object mLock = new Object();
    @NonNull
    private final Surface mSurface;
    private final int mTargets;
    private final int mFormat;
    @NonNull
    private final Size mSize;
    private final SurfaceOutput.GlTransformOptions mGlTransformOptions;
    private final Size mInputSize;
    private final Rect mInputCropRect;
    private final int mRotationDegrees;
    private final boolean mMirroring;
    @NonNull
    private final float[] mGlTransform = new float[16];
    @GuardedBy(value="mLock")
    @Nullable
    private Consumer<SurfaceOutput.Event> mEventListener;
    @GuardedBy(value="mLock")
    @Nullable
    private Executor mExecutor;
    @GuardedBy(value="mLock")
    private boolean mHasPendingCloseRequest = false;
    @GuardedBy(value="mLock")
    private boolean mIsClosed = false;
    @NonNull
    private final ListenableFuture<Void> mCloseFuture;
    private CallbackToFutureAdapter.Completer<Void> mCloseFutureCompleter;

    SurfaceOutputImpl(@NonNull Surface surface, int targets, int format, @NonNull Size size, @NonNull SurfaceOutput.GlTransformOptions glTransformOptions, @NonNull Size inputSize, @NonNull Rect inputCropRect, int rotationDegree, boolean mirroring) {
        this.mSurface = surface;
        this.mTargets = targets;
        this.mFormat = format;
        this.mSize = size;
        this.mGlTransformOptions = glTransformOptions;
        this.mInputSize = inputSize;
        this.mInputCropRect = new Rect(inputCropRect);
        this.mMirroring = mirroring;
        if (this.mGlTransformOptions == SurfaceOutput.GlTransformOptions.APPLY_CROP_ROTATE_AND_MIRRORING) {
            this.mRotationDegrees = rotationDegree;
            this.calculateGlTransform();
        } else {
            this.mRotationDegrees = 0;
        }
        this.mCloseFuture = CallbackToFutureAdapter.getFuture(completer -> {
            this.mCloseFutureCompleter = completer;
            return "SurfaceOutputImpl close future complete";
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public Surface getSurface(@NonNull Executor executor, @NonNull Consumer<SurfaceOutput.Event> listener) {
        boolean hasPendingCloseRequest;
        Object object = this.mLock;
        synchronized (object) {
            this.mExecutor = executor;
            this.mEventListener = listener;
            hasPendingCloseRequest = this.mHasPendingCloseRequest;
        }
        if (hasPendingCloseRequest) {
            this.requestClose();
        }
        return this.mSurface;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestClose() {
        AtomicReference<Consumer<SurfaceOutput.Event>> eventListenerRef = new AtomicReference<Consumer<SurfaceOutput.Event>>();
        Executor executor = null;
        Object object = this.mLock;
        synchronized (object) {
            if (this.mExecutor == null || this.mEventListener == null) {
                this.mHasPendingCloseRequest = true;
            } else if (!this.mIsClosed) {
                eventListenerRef.set(this.mEventListener);
                executor = this.mExecutor;
                this.mHasPendingCloseRequest = false;
            }
        }
        if (executor != null) {
            try {
                executor.execute(() -> ((Consumer)eventListenerRef.get()).accept((Object)SurfaceOutput.Event.of(0, this)));
            }
            catch (RejectedExecutionException e) {
                Logger.d(TAG, "Processor executor closed. Close request not posted.", e);
            }
        }
    }

    @Override
    public int getTargets() {
        return this.mTargets;
    }

    @Override
    @NonNull
    public Size getSize() {
        return this.mSize;
    }

    @Override
    public int getFormat() {
        return this.mFormat;
    }

    @Override
    public int getRotationDegrees() {
        return this.mRotationDegrees;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @AnyThread
    public void close() {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mIsClosed) {
                this.mIsClosed = true;
            }
        }
        this.mCloseFutureCompleter.set(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RestrictTo(value={RestrictTo.Scope.TESTS})
    public boolean isClosed() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mIsClosed;
        }
    }

    @NonNull
    public ListenableFuture<Void> getCloseFuture() {
        return this.mCloseFuture;
    }

    @Override
    @AnyThread
    public void updateTransformMatrix(@NonNull float[] output, @NonNull float[] input) {
        switch (this.mGlTransformOptions) {
            case USE_SURFACE_TEXTURE_TRANSFORM: {
                System.arraycopy(input, 0, output, 0, 16);
                break;
            }
            case APPLY_CROP_ROTATE_AND_MIRRORING: {
                System.arraycopy(this.mGlTransform, 0, output, 0, 16);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown GlTransformOptions: " + (Object)((Object)this.mGlTransformOptions)));
            }
        }
    }

    private void calculateGlTransform() {
        Matrix.setIdentityM((float[])this.mGlTransform, (int)0);
        Matrix.translateM((float[])this.mGlTransform, (int)0, (float)0.0f, (float)1.0f, (float)0.0f);
        Matrix.scaleM((float[])this.mGlTransform, (int)0, (float)1.0f, (float)-1.0f, (float)1.0f);
        MatrixExt.preRotate(this.mGlTransform, this.mRotationDegrees, 0.5f, 0.5f);
        if (this.mMirroring) {
            Matrix.translateM((float[])this.mGlTransform, (int)0, (float)1.0f, (float)0.0f, (float)0.0f);
            Matrix.scaleM((float[])this.mGlTransform, (int)0, (float)-1.0f, (float)1.0f, (float)1.0f);
        }
        Size rotatedSize = TransformUtils.rotateSize(this.mInputSize, this.mRotationDegrees);
        android.graphics.Matrix imageTransform = TransformUtils.getRectToRect(TransformUtils.sizeToRectF(this.mInputSize), TransformUtils.sizeToRectF(rotatedSize), this.mRotationDegrees, this.mMirroring);
        RectF rotatedCroppedRect = new RectF(this.mInputCropRect);
        imageTransform.mapRect(rotatedCroppedRect);
        float offsetX = rotatedCroppedRect.left / (float)rotatedSize.getWidth();
        float offsetY = ((float)rotatedSize.getHeight() - rotatedCroppedRect.height() - rotatedCroppedRect.top) / (float)rotatedSize.getHeight();
        float scaleX = rotatedCroppedRect.width() / (float)rotatedSize.getWidth();
        float scaleY = rotatedCroppedRect.height() / (float)rotatedSize.getHeight();
        Matrix.translateM((float[])this.mGlTransform, (int)0, (float)offsetX, (float)offsetY, (float)0.0f);
        Matrix.scaleM((float[])this.mGlTransform, (int)0, (float)scaleX, (float)scaleY, (float)1.0f);
    }
}

