/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.processing;

import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import androidx.camera.core.SurfaceOutput;
import androidx.camera.core.SurfaceProcessor;
import androidx.camera.core.SurfaceRequest;
import androidx.camera.core.processing.SurfaceProcessorInternal;
import androidx.core.util.Preconditions;
import java.util.concurrent.Executor;

public class SurfaceProcessorWithExecutor
implements SurfaceProcessorInternal {
    @NonNull
    private final SurfaceProcessor mSurfaceProcessor;
    @NonNull
    private final Executor mExecutor;

    public SurfaceProcessorWithExecutor(@NonNull SurfaceProcessor surfaceProcessor, @NonNull Executor executor) {
        Preconditions.checkState((!(surfaceProcessor instanceof SurfaceProcessorInternal) ? 1 : 0) != 0, (String)"SurfaceProcessorInternal should always be thread safe. Do not wrap.");
        this.mSurfaceProcessor = surfaceProcessor;
        this.mExecutor = executor;
    }

    @NonNull
    @VisibleForTesting
    public SurfaceProcessor getProcessor() {
        return this.mSurfaceProcessor;
    }

    @NonNull
    @VisibleForTesting
    public Executor getExecutor() {
        return this.mExecutor;
    }

    @Override
    public void onInputSurface(@NonNull SurfaceRequest request) {
        this.mExecutor.execute(() -> this.mSurfaceProcessor.onInputSurface(request));
    }

    @Override
    public void onOutputSurface(@NonNull SurfaceOutput surfaceOutput) {
        this.mExecutor.execute(() -> this.mSurfaceProcessor.onOutputSurface(surfaceOutput));
    }

    @Override
    public void release() {
    }
}

