/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.imagecapture;

import android.graphics.Bitmap;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.camera.core.ImageCaptureException;
import androidx.camera.core.imagecapture.AutoValue_Bitmap2JpegBytes_In;
import androidx.camera.core.processing.Operation;
import androidx.camera.core.processing.Packet;
import com.google.auto.value.AutoValue;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Objects;

@RequiresApi(api=21)
class Bitmap2JpegBytes
implements Operation<In, Packet<byte[]>> {
    Bitmap2JpegBytes() {
    }

    @Override
    @NonNull
    public Packet<byte[]> apply(@NonNull In in) throws ImageCaptureException {
        Packet<Bitmap> packet = in.getPacket();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        packet.getData().compress(Bitmap.CompressFormat.JPEG, in.getJpegQuality(), (OutputStream)outputStream);
        return Packet.of(outputStream.toByteArray(), Objects.requireNonNull(packet.getExif()), 256, packet.getSize(), packet.getCropRect(), packet.getRotationDegrees(), packet.getSensorToBufferTransform(), packet.getCameraCaptureResult());
    }

    @AutoValue
    static abstract class In {
        In() {
        }

        abstract Packet<Bitmap> getPacket();

        abstract int getJpegQuality();

        @NonNull
        static In of(@NonNull Packet<Bitmap> imagePacket, int jpegQuality) {
            return new AutoValue_Bitmap2JpegBytes_In(imagePacket, jpegQuality);
        }
    }
}

