/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.camera.core.impl.AutoValue_Config_Option;
import androidx.camera.core.impl.ImageOutputConfig;
import androidx.camera.core.impl.MutableOptionsBundle;
import androidx.camera.core.impl.OptionsBundle;
import androidx.camera.core.impl.utils.ResolutionSelectorUtil;
import androidx.camera.core.resolutionselector.ResolutionSelector;
import com.google.auto.value.AutoValue;
import java.util.Objects;
import java.util.Set;

@RequiresApi(value=21)
public interface Config {
    public boolean containsOption(@NonNull Option<?> var1);

    @Nullable
    public <ValueT> ValueT retrieveOption(@NonNull Option<ValueT> var1);

    @Nullable
    public <ValueT> ValueT retrieveOption(@NonNull Option<ValueT> var1, @Nullable ValueT var2);

    @Nullable
    public <ValueT> ValueT retrieveOptionWithPriority(@NonNull Option<ValueT> var1, @NonNull OptionPriority var2);

    @NonNull
    public OptionPriority getOptionPriority(@NonNull Option<?> var1);

    public void findOptions(@NonNull String var1, @NonNull OptionMatcher var2);

    @NonNull
    public Set<Option<?>> listOptions();

    @NonNull
    public Set<OptionPriority> getPriorities(@NonNull Option<?> var1);

    public static boolean hasConflict(@NonNull OptionPriority priority1, @NonNull OptionPriority priority2) {
        if (priority1 == OptionPriority.ALWAYS_OVERRIDE && priority2 == OptionPriority.ALWAYS_OVERRIDE) {
            return true;
        }
        return priority1 == OptionPriority.REQUIRED && priority2 == OptionPriority.REQUIRED;
    }

    @NonNull
    public static Config mergeConfigs(@Nullable Config extendedConfig, @Nullable Config baseConfig) {
        if (extendedConfig == null && baseConfig == null) {
            return OptionsBundle.emptyBundle();
        }
        MutableOptionsBundle mergedConfig = baseConfig != null ? MutableOptionsBundle.from(baseConfig) : MutableOptionsBundle.create();
        if (extendedConfig != null) {
            for (Option<?> opt : extendedConfig.listOptions()) {
                Config.mergeOptionValue(mergedConfig, baseConfig, extendedConfig, opt);
            }
        }
        return OptionsBundle.from(mergedConfig);
    }

    public static void mergeOptionValue(@NonNull MutableOptionsBundle mergedConfig, @NonNull Config baseConfig, @NonNull Config extendedConfig, @NonNull Option<?> opt) {
        Option<?> objectOpt = opt;
        if (Objects.equals(objectOpt, ImageOutputConfig.OPTION_RESOLUTION_SELECTOR)) {
            ResolutionSelector resolutionSelectorToOverride = extendedConfig.retrieveOption(objectOpt, null);
            ResolutionSelector baseResolutionSelector = baseConfig.retrieveOption(objectOpt, null);
            mergedConfig.insertOption(objectOpt, extendedConfig.getOptionPriority(opt), ResolutionSelectorUtil.overrideResolutionSelectors(baseResolutionSelector, resolutionSelectorToOverride));
        } else {
            mergedConfig.insertOption(objectOpt, extendedConfig.getOptionPriority(opt), extendedConfig.retrieveOption(objectOpt));
        }
    }

    public static enum OptionPriority {
        ALWAYS_OVERRIDE,
        REQUIRED,
        OPTIONAL;

    }

    @AutoValue
    public static abstract class Option<T> {
        Option() {
        }

        @NonNull
        public static <T> Option<T> create(@NonNull String id, @NonNull Class<?> valueClass) {
            return Option.create(id, valueClass, null);
        }

        @NonNull
        public static <T> Option<T> create(@NonNull String id, @NonNull Class<?> valueClass, @Nullable Object token) {
            return new AutoValue_Config_Option(id, valueClass, token);
        }

        @NonNull
        public abstract String getId();

        @NonNull
        public abstract Class<T> getValueClass();

        @Nullable
        public abstract Object getToken();
    }

    public static interface OptionMatcher {
        public boolean onOptionMatched(@NonNull Option<?> var1);
    }
}

