/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.camera.core.impl.EncoderProfilesProvider;
import androidx.camera.core.impl.EncoderProfilesProxy;
import androidx.camera.core.impl.EncoderProfilesResolutionValidator;
import androidx.camera.core.impl.Quirks;
import androidx.camera.core.impl.quirk.ProfileResolutionQuirk;
import java.util.List;

@RequiresApi(value=21)
public class ResolutionValidatedEncoderProfilesProvider
implements EncoderProfilesProvider {
    private final EncoderProfilesProvider mProvider;
    private final EncoderProfilesResolutionValidator mEncoderProfilesResolutionValidator;

    public ResolutionValidatedEncoderProfilesProvider(@NonNull EncoderProfilesProvider provider, @NonNull Quirks quirks) {
        this.mProvider = provider;
        List<ProfileResolutionQuirk> resolutionQuirks = quirks.getAll(ProfileResolutionQuirk.class);
        this.mEncoderProfilesResolutionValidator = new EncoderProfilesResolutionValidator(resolutionQuirks);
    }

    @Override
    public boolean hasProfile(int quality) {
        if (!this.mProvider.hasProfile(quality)) {
            return false;
        }
        if (this.mEncoderProfilesResolutionValidator.hasQuirk()) {
            EncoderProfilesProxy profiles = this.mProvider.getAll(quality);
            return this.mEncoderProfilesResolutionValidator.hasValidVideoResolution(profiles);
        }
        return true;
    }

    @Override
    @Nullable
    public EncoderProfilesProxy getAll(int quality) {
        if (!this.mProvider.hasProfile(quality)) {
            return null;
        }
        EncoderProfilesProxy profiles = this.mProvider.getAll(quality);
        if (this.mEncoderProfilesResolutionValidator.hasQuirk()) {
            profiles = this.mEncoderProfilesResolutionValidator.filterInvalidVideoResolution(profiles);
        }
        return profiles;
    }
}

