/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.processing;

import android.graphics.Matrix;
import android.graphics.Rect;
import android.util.Size;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.core.impl.CameraCaptureResult;
import androidx.camera.core.impl.utils.Exif;
import androidx.camera.core.processing.Packet;

final class AutoValue_Packet<T>
extends Packet<T> {
    private final T data;
    private final Exif exif;
    private final int format;
    private final Size size;
    private final Rect cropRect;
    private final int rotationDegrees;
    private final Matrix sensorToBufferTransform;
    private final CameraCaptureResult cameraCaptureResult;

    AutoValue_Packet(T data, @Nullable Exif exif, int format, Size size, Rect cropRect, int rotationDegrees, Matrix sensorToBufferTransform, CameraCaptureResult cameraCaptureResult) {
        if (data == null) {
            throw new NullPointerException("Null data");
        }
        this.data = data;
        this.exif = exif;
        this.format = format;
        if (size == null) {
            throw new NullPointerException("Null size");
        }
        this.size = size;
        if (cropRect == null) {
            throw new NullPointerException("Null cropRect");
        }
        this.cropRect = cropRect;
        this.rotationDegrees = rotationDegrees;
        if (sensorToBufferTransform == null) {
            throw new NullPointerException("Null sensorToBufferTransform");
        }
        this.sensorToBufferTransform = sensorToBufferTransform;
        if (cameraCaptureResult == null) {
            throw new NullPointerException("Null cameraCaptureResult");
        }
        this.cameraCaptureResult = cameraCaptureResult;
    }

    @Override
    @NonNull
    public T getData() {
        return this.data;
    }

    @Override
    @Nullable
    public Exif getExif() {
        return this.exif;
    }

    @Override
    public int getFormat() {
        return this.format;
    }

    @Override
    @NonNull
    public Size getSize() {
        return this.size;
    }

    @Override
    @NonNull
    public Rect getCropRect() {
        return this.cropRect;
    }

    @Override
    public int getRotationDegrees() {
        return this.rotationDegrees;
    }

    @Override
    @NonNull
    public Matrix getSensorToBufferTransform() {
        return this.sensorToBufferTransform;
    }

    @Override
    @NonNull
    public CameraCaptureResult getCameraCaptureResult() {
        return this.cameraCaptureResult;
    }

    public String toString() {
        return "Packet{data=" + this.data + ", exif=" + this.exif + ", format=" + this.format + ", size=" + this.size + ", cropRect=" + this.cropRect + ", rotationDegrees=" + this.rotationDegrees + ", sensorToBufferTransform=" + this.sensorToBufferTransform + ", cameraCaptureResult=" + this.cameraCaptureResult + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Packet) {
            Packet that = (Packet)o;
            return this.data.equals(that.getData()) && (this.exif == null ? that.getExif() == null : this.exif.equals(that.getExif())) && this.format == that.getFormat() && this.size.equals((Object)that.getSize()) && this.cropRect.equals((Object)that.getCropRect()) && this.rotationDegrees == that.getRotationDegrees() && this.sensorToBufferTransform.equals((Object)that.getSensorToBufferTransform()) && this.cameraCaptureResult.equals(that.getCameraCaptureResult());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.data.hashCode();
        h$ *= 1000003;
        h$ ^= this.exif == null ? 0 : this.exif.hashCode();
        h$ *= 1000003;
        h$ ^= this.format;
        h$ *= 1000003;
        h$ ^= this.size.hashCode();
        h$ *= 1000003;
        h$ ^= this.cropRect.hashCode();
        h$ *= 1000003;
        h$ ^= this.rotationDegrees;
        h$ *= 1000003;
        h$ ^= this.sensorToBufferTransform.hashCode();
        h$ *= 1000003;
        return h$ ^= this.cameraCaptureResult.hashCode();
    }
}

