/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.resolutionselector;

import android.util.Size;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

@RequiresApi(value=21)
public final class ResolutionStrategy {
    @NonNull
    public static final ResolutionStrategy HIGHEST_AVAILABLE_STRATEGY = new ResolutionStrategy();
    public static final int FALLBACK_RULE_NONE = 0;
    public static final int FALLBACK_RULE_CLOSEST_HIGHER_THEN_LOWER = 1;
    public static final int FALLBACK_RULE_CLOSEST_HIGHER = 2;
    public static final int FALLBACK_RULE_CLOSEST_LOWER_THEN_HIGHER = 3;
    public static final int FALLBACK_RULE_CLOSEST_LOWER = 4;
    @Nullable
    private Size mBoundSize = null;
    private int mFallbackRule = 0;

    private ResolutionStrategy() {
    }

    public ResolutionStrategy(@NonNull Size boundSize, int fallbackRule) {
        this.mBoundSize = boundSize;
        this.mFallbackRule = fallbackRule;
    }

    @Nullable
    public Size getBoundSize() {
        return this.mBoundSize;
    }

    public int getFallbackRule() {
        return this.mFallbackRule;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface ResolutionFallbackRule {
    }
}

