/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.internal.compat.quirk;

import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.camera.core.ImageProxy;
import androidx.camera.core.impl.Quirk;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

@RequiresApi(value=21)
public final class IncorrectJpegMetadataQuirk
implements Quirk {
    private static final Set<String> SAMSUNG_DEVICES = new HashSet<String>(Arrays.asList("A24"));

    static boolean load() {
        return IncorrectJpegMetadataQuirk.isSamsungProblematicDevice();
    }

    private static boolean isSamsungProblematicDevice() {
        return "Samsung".equalsIgnoreCase(Build.BRAND) && SAMSUNG_DEVICES.contains(Build.DEVICE.toUpperCase(Locale.US));
    }

    @NonNull
    public byte[] jpegImageToJpegByteArray(@NonNull ImageProxy imageProxy) {
        ByteBuffer byteBuffer = imageProxy.getPlanes()[0].getBuffer();
        byte[] bytes = new byte[byteBuffer.capacity()];
        byteBuffer.rewind();
        byteBuffer.get(bytes);
        int copyStartPos = 0;
        if (!this.canParseSosMarker(bytes)) {
            int secondFfd8Position = this.findSecondFfd8Position(bytes);
            if (secondFfd8Position != -1) {
                copyStartPos = secondFfd8Position;
            } else {
                return bytes;
            }
        }
        return Arrays.copyOfRange(bytes, copyStartPos, byteBuffer.limit());
    }

    private boolean canParseSosMarker(@NonNull byte[] bytes) {
        int markPosition = 2;
        while (markPosition + 4 <= bytes.length && bytes[markPosition] == -1) {
            if (bytes[markPosition] == -1 && bytes[markPosition + 1] == -38) {
                return true;
            }
            int segmentLength = (bytes[markPosition + 2] & 0xFF) << 8 | bytes[markPosition + 3] & 0xFF;
            markPosition += segmentLength + 2;
        }
        return false;
    }

    private int findSecondFfd8Position(@NonNull byte[] bytes) {
        int position = 2;
        while (position + 1 <= bytes.length) {
            if (bytes[position] == -1 && bytes[position + 1] == -40) {
                return position;
            }
            ++position;
        }
        return -1;
    }
}

