/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.internal.compat.workaround;

import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.camera.core.ImageProxy;
import androidx.camera.core.impl.Quirks;
import androidx.camera.core.internal.compat.quirk.IncorrectJpegMetadataQuirk;
import java.nio.ByteBuffer;

@RequiresApi(value=21)
public class JpegMetadataCorrector {
    private final IncorrectJpegMetadataQuirk mQuirk;

    public JpegMetadataCorrector(@NonNull Quirks quirks) {
        this.mQuirk = quirks.get(IncorrectJpegMetadataQuirk.class);
    }

    public boolean needCorrectJpegMetadata() {
        return this.mQuirk != null;
    }

    @NonNull
    public byte[] jpegImageToJpegByteArray(@NonNull ImageProxy image) {
        if (this.mQuirk == null) {
            ImageProxy.PlaneProxy[] planes = image.getPlanes();
            ByteBuffer buffer = planes[0].getBuffer();
            byte[] data = new byte[buffer.capacity()];
            buffer.rewind();
            buffer.get(data);
            return data;
        }
        return this.mQuirk.jpegImageToJpegByteArray(image);
    }
}

