/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.streamsharing;

import android.util.Size;
import androidx.annotation.IntRange;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import androidx.camera.core.ImageCapture;
import androidx.camera.core.Preview;
import androidx.camera.core.UseCase;
import androidx.camera.core.impl.CameraCaptureCallback;
import androidx.camera.core.impl.CameraCaptureResult;
import androidx.camera.core.impl.CameraControlInternal;
import androidx.camera.core.impl.CameraInfoInternal;
import androidx.camera.core.impl.CameraInternal;
import androidx.camera.core.impl.DeferrableSurface;
import androidx.camera.core.impl.ImageOutputConfig;
import androidx.camera.core.impl.MutableConfig;
import androidx.camera.core.impl.Observable;
import androidx.camera.core.impl.SessionConfig;
import androidx.camera.core.impl.UseCaseConfig;
import androidx.camera.core.impl.UseCaseConfigFactory;
import androidx.camera.core.impl.utils.Threads;
import androidx.camera.core.impl.utils.TransformUtils;
import androidx.camera.core.processing.SurfaceEdge;
import androidx.camera.core.processing.SurfaceProcessorNode;
import androidx.camera.core.streamsharing.ResolutionUtils;
import androidx.camera.core.streamsharing.StreamSharing;
import androidx.camera.core.streamsharing.VirtualCameraCaptureResult;
import androidx.camera.core.streamsharing.VirtualCameraControl;
import androidx.core.util.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@RequiresApi(api=21)
class VirtualCamera
implements CameraInternal {
    private static final String UNSUPPORTED_MESSAGE = "Operation not supported by VirtualCamera.";
    @NonNull
    final Set<UseCase> mChildren;
    @NonNull
    final Map<UseCase, SurfaceEdge> mChildrenEdges = new HashMap<UseCase, SurfaceEdge>();
    @NonNull
    final Map<UseCase, Boolean> mChildrenActiveState = new HashMap<UseCase, Boolean>();
    @NonNull
    private final UseCaseConfigFactory mUseCaseConfigFactory;
    @NonNull
    private final CameraInternal mParentCamera;
    @NonNull
    private final CameraCaptureCallback mParentMetadataCallback = this.createCameraCaptureCallback();
    @NonNull
    private final VirtualCameraControl mVirtualCameraControl;

    VirtualCamera(@NonNull CameraInternal parentCamera, @NonNull Set<UseCase> children, @NonNull UseCaseConfigFactory useCaseConfigFactory, @NonNull StreamSharing.Control streamSharingControl) {
        this.mParentCamera = parentCamera;
        this.mUseCaseConfigFactory = useCaseConfigFactory;
        this.mChildren = children;
        this.mVirtualCameraControl = new VirtualCameraControl(parentCamera.getCameraControlInternal(), streamSharingControl);
        for (UseCase child : children) {
            this.mChildrenActiveState.put(child, false);
        }
    }

    void mergeChildrenConfigs(@NonNull MutableConfig mutableConfig) {
        HashSet childrenConfigs = new HashSet();
        for (UseCase useCase : this.mChildren) {
            childrenConfigs.add(useCase.mergeConfigs(this.mParentCamera.getCameraInfoInternal(), null, useCase.getDefaultConfig(true, this.mUseCaseConfigFactory)));
        }
        ArrayList<Size> supportedResolutions = new ArrayList<Size>(this.mParentCamera.getCameraInfoInternal().getSupportedResolutions(34));
        Size sensorSize = TransformUtils.rectToSize(this.mParentCamera.getCameraControlInternal().getSensorRect());
        mutableConfig.insertOption(ImageOutputConfig.OPTION_CUSTOM_ORDERED_RESOLUTIONS, ResolutionUtils.getMergedResolutions(supportedResolutions, sensorSize, childrenConfigs));
        mutableConfig.insertOption(UseCaseConfig.OPTION_SURFACE_OCCUPANCY_PRIORITY, VirtualCamera.getHighestSurfacePriority(childrenConfigs));
    }

    void bindChildren() {
        for (UseCase useCase : this.mChildren) {
            useCase.bindToCamera(this, null, useCase.getDefaultConfig(true, this.mUseCaseConfigFactory));
        }
    }

    void unbindChildren() {
        for (UseCase useCase : this.mChildren) {
            useCase.unbindFromCamera(this);
        }
    }

    void notifyStateAttached() {
        for (UseCase useCase : this.mChildren) {
            useCase.onStateAttached();
        }
    }

    void notifyStateDetached() {
        for (UseCase useCase : this.mChildren) {
            useCase.onStateDetached();
        }
    }

    @NonNull
    Set<UseCase> getChildren() {
        return this.mChildren;
    }

    @NonNull
    Map<UseCase, SurfaceProcessorNode.OutConfig> getChildrenOutConfigs(@NonNull SurfaceEdge cameraEdge) {
        HashMap<UseCase, SurfaceProcessorNode.OutConfig> outConfigs = new HashMap<UseCase, SurfaceProcessorNode.OutConfig>();
        for (UseCase useCase : this.mChildren) {
            int rotationDegrees = this.getChildRotationDegrees(useCase);
            outConfigs.put(useCase, SurfaceProcessorNode.OutConfig.of(VirtualCamera.getChildTargetType(useCase), VirtualCamera.getChildFormat(useCase), cameraEdge.getCropRect(), TransformUtils.getRotatedSize(cameraEdge.getCropRect(), rotationDegrees), rotationDegrees, useCase.isMirroringRequired(this)));
        }
        return outConfigs;
    }

    void setChildrenEdges(@NonNull Map<UseCase, SurfaceEdge> childrenEdges) {
        this.mChildrenEdges.clear();
        this.mChildrenEdges.putAll(childrenEdges);
        for (Map.Entry<UseCase, SurfaceEdge> entry : this.mChildrenEdges.entrySet()) {
            UseCase useCase = entry.getKey();
            SurfaceEdge surfaceEdge = entry.getValue();
            useCase.setViewPortCropRect(surfaceEdge.getCropRect());
            useCase.setSensorToBufferTransformMatrix(surfaceEdge.getSensorToBufferTransform());
            useCase.updateSuggestedStreamSpec(surfaceEdge.getStreamSpec());
            useCase.notifyState();
        }
    }

    void resetChildren() {
        Threads.checkMainThread();
        for (UseCase useCase : this.mChildren) {
            this.onUseCaseReset(useCase);
        }
    }

    @NonNull
    CameraCaptureCallback getParentMetadataCallback() {
        return this.mParentMetadataCallback;
    }

    @Override
    @MainThread
    public void onUseCaseActive(@NonNull UseCase useCase) {
        Threads.checkMainThread();
        if (this.isUseCaseActive(useCase)) {
            return;
        }
        this.mChildrenActiveState.put(useCase, true);
        DeferrableSurface childSurface = VirtualCamera.getChildSurface(useCase);
        if (childSurface != null) {
            this.forceSetProvider(this.getUseCaseEdge(useCase), childSurface, useCase.getSessionConfig());
        }
    }

    @Override
    @MainThread
    public void onUseCaseInactive(@NonNull UseCase useCase) {
        Threads.checkMainThread();
        if (!this.isUseCaseActive(useCase)) {
            return;
        }
        this.mChildrenActiveState.put(useCase, false);
        this.getUseCaseEdge(useCase).disconnect();
    }

    @Override
    @MainThread
    public void onUseCaseUpdated(@NonNull UseCase useCase) {
        Threads.checkMainThread();
        if (!this.isUseCaseActive(useCase)) {
            return;
        }
        SurfaceEdge edge = this.getUseCaseEdge(useCase);
        DeferrableSurface childSurface = VirtualCamera.getChildSurface(useCase);
        if (childSurface != null) {
            this.forceSetProvider(edge, childSurface, useCase.getSessionConfig());
        } else {
            edge.disconnect();
        }
    }

    @Override
    @MainThread
    public void onUseCaseReset(@NonNull UseCase useCase) {
        Threads.checkMainThread();
        SurfaceEdge edge = this.getUseCaseEdge(useCase);
        edge.invalidate();
        if (!this.isUseCaseActive(useCase)) {
            return;
        }
        DeferrableSurface childSurface = VirtualCamera.getChildSurface(useCase);
        if (childSurface != null) {
            this.forceSetProvider(edge, childSurface, useCase.getSessionConfig());
        }
    }

    @Override
    public boolean getHasTransform() {
        return false;
    }

    @Override
    @NonNull
    public CameraControlInternal getCameraControlInternal() {
        return this.mVirtualCameraControl;
    }

    @Override
    @NonNull
    public CameraInfoInternal getCameraInfoInternal() {
        return this.mParentCamera.getCameraInfoInternal();
    }

    @Override
    @NonNull
    public Observable<CameraInternal.State> getCameraState() {
        return this.mParentCamera.getCameraState();
    }

    @IntRange(from=0L, to=359L)
    private int getChildRotationDegrees(@NonNull UseCase child) {
        if (child instanceof Preview) {
            return this.mParentCamera.getCameraInfo().getSensorRotationDegrees(((Preview)child).getTargetRotation());
        }
        return 0;
    }

    private static int getChildFormat(@NonNull UseCase useCase) {
        return useCase instanceof ImageCapture ? 256 : 34;
    }

    private static int getChildTargetType(@NonNull UseCase useCase) {
        if (useCase instanceof Preview) {
            return 1;
        }
        if (useCase instanceof ImageCapture) {
            return 4;
        }
        return 2;
    }

    private static int getHighestSurfacePriority(Set<UseCaseConfig<?>> childrenConfigs) {
        int highestPriority = 0;
        for (UseCaseConfig<?> childConfig : childrenConfigs) {
            highestPriority = Math.max(highestPriority, childConfig.getSurfaceOccupancyPriority());
        }
        return highestPriority;
    }

    @NonNull
    private SurfaceEdge getUseCaseEdge(@NonNull UseCase useCase) {
        return Objects.requireNonNull(this.mChildrenEdges.get(useCase));
    }

    private boolean isUseCaseActive(@NonNull UseCase useCase) {
        return Objects.requireNonNull(this.mChildrenActiveState.get(useCase));
    }

    private void forceSetProvider(@NonNull SurfaceEdge edge, @NonNull DeferrableSurface childSurface, @NonNull SessionConfig childSessionConfig) {
        edge.invalidate();
        try {
            edge.setProvider(childSurface);
        }
        catch (DeferrableSurface.SurfaceClosedException e) {
            for (SessionConfig.ErrorListener listener : childSessionConfig.getErrorListeners()) {
                listener.onError(childSessionConfig, SessionConfig.SessionError.SESSION_ERROR_SURFACE_NEEDS_RESET);
            }
        }
    }

    @VisibleForTesting
    @Nullable
    static DeferrableSurface getChildSurface(@NonNull UseCase child) {
        List<DeferrableSurface> surfaces = child instanceof ImageCapture ? child.getSessionConfig().getSurfaces() : child.getSessionConfig().getRepeatingCaptureConfig().getSurfaces();
        Preconditions.checkState((surfaces.size() <= 1 ? 1 : 0) != 0);
        if (surfaces.size() == 1) {
            return surfaces.get(0);
        }
        return null;
    }

    CameraCaptureCallback createCameraCaptureCallback() {
        return new CameraCaptureCallback(){

            @Override
            public void onCaptureCompleted(@NonNull CameraCaptureResult cameraCaptureResult) {
                super.onCaptureCompleted(cameraCaptureResult);
                for (UseCase child : VirtualCamera.this.mChildren) {
                    VirtualCamera.sendCameraCaptureResultToChild(cameraCaptureResult, child.getSessionConfig());
                }
            }
        };
    }

    static void sendCameraCaptureResultToChild(@NonNull CameraCaptureResult cameraCaptureResult, @NonNull SessionConfig sessionConfig) {
        for (CameraCaptureCallback callback : sessionConfig.getRepeatingCameraCaptureCallbacks()) {
            callback.onCaptureCompleted(new VirtualCameraCaptureResult(sessionConfig.getRepeatingCaptureConfig().getTagBundle(), cameraCaptureResult));
        }
    }

    @Override
    public void open() {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    @Override
    public void close() {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    @Override
    @NonNull
    public ListenableFuture<Void> release() {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    @Override
    public void attachUseCases(@NonNull Collection<UseCase> useCases) {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    @Override
    public void detachUseCases(@NonNull Collection<UseCase> useCases) {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }
}

