/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.processing;

import androidx.annotation.NonNull;
import androidx.core.util.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;

public class TargetUtils {
    private TargetUtils() {
    }

    public static int getNumberOfTargets(int targets) {
        int count = 0;
        while (targets != 0) {
            count += targets & 1;
            targets >>= 1;
        }
        return count;
    }

    public static boolean isSuperset(int superset, int subset) {
        return (superset & subset) == subset;
    }

    public static void checkSupportedTargets(@NonNull Collection<Integer> supportedTargets, int targets) {
        Preconditions.checkArgument((boolean)supportedTargets.contains(targets), (Object)String.format(Locale.US, "Effects target %s is not in the supported list %s.", TargetUtils.getHumanReadableName(targets), TargetUtils.getHumanReadableNames(supportedTargets)));
    }

    @NonNull
    private static String getHumanReadableNames(@NonNull Collection<Integer> targets) {
        ArrayList<String> targetNameList = new ArrayList<String>();
        for (Integer target : targets) {
            targetNameList.add(TargetUtils.getHumanReadableName(target));
        }
        return "[" + String.join((CharSequence)", ", targetNameList) + "]";
    }

    @NonNull
    public static String getHumanReadableName(int target) {
        ArrayList<String> names = new ArrayList<String>();
        if ((target & 4) != 0) {
            names.add("IMAGE_CAPTURE");
        }
        if ((target & 1) != 0) {
            names.add("PREVIEW");
        }
        if ((target & 2) != 0) {
            names.add("VIDEO_CAPTURE");
        }
        return String.join((CharSequence)"|", names);
    }
}

