/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.imagecapture;

import android.graphics.Bitmap;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.camera.core.ImageCaptureException;
import androidx.camera.core.ImageProcessingUtil;
import androidx.camera.core.ImageProxy;
import androidx.camera.core.ImageReaderProxys;
import androidx.camera.core.SafeCloseImageReaderProxy;
import androidx.camera.core.internal.utils.ImageUtil;
import androidx.camera.core.processing.Operation;
import androidx.camera.core.processing.Packet;
import java.nio.ByteBuffer;

@RequiresApi(api=21)
public class Image2Bitmap
implements Operation<Packet<ImageProxy>, Bitmap> {
    @Override
    @NonNull
    public Bitmap apply(@NonNull Packet<ImageProxy> imageProxyPacket) throws ImageCaptureException {
        try (SafeCloseImageReaderProxy rgbImageReader = null;){
            ImageProxy jpegImage;
            Bitmap result;
            if (imageProxyPacket.getFormat() == 35) {
                ImageProxy yuvImage = imageProxyPacket.getData();
                boolean needFlip = imageProxyPacket.getRotationDegrees() % 180 != 0;
                int tempImageReaderWidth = needFlip ? yuvImage.getHeight() : yuvImage.getWidth();
                int tempImageReaderHeight = needFlip ? yuvImage.getWidth() : yuvImage.getHeight();
                rgbImageReader = new SafeCloseImageReaderProxy(ImageReaderProxys.createIsolatedReader(tempImageReaderWidth, tempImageReaderHeight, 1, 2));
                ByteBuffer rgbConvertedBuffer = ByteBuffer.allocateDirect(yuvImage.getWidth() * yuvImage.getHeight() * 4);
                ImageProxy imageProxyRGB = ImageProcessingUtil.convertYUVToRGB(yuvImage, rgbImageReader, rgbConvertedBuffer, imageProxyPacket.getRotationDegrees(), false);
                yuvImage.close();
                if (imageProxyRGB == null) {
                    throw new ImageCaptureException(0, "Can't covert YUV to RGB", null);
                }
                Bitmap bitmap = ImageUtil.createBitmapFromImageProxy(imageProxyRGB);
                imageProxyRGB.close();
                result = bitmap;
            } else if (imageProxyPacket.getFormat() == 256) {
                jpegImage = imageProxyPacket.getData();
                Bitmap bitmap = ImageUtil.createBitmapFromImageProxy(jpegImage);
                jpegImage.close();
                result = ImageUtil.rotateBitmap(bitmap, imageProxyPacket.getRotationDegrees());
            } else {
                throw new IllegalArgumentException("Invalid postview image format : " + imageProxyPacket.getFormat());
            }
            jpegImage = result;
            return jpegImage;
        }
    }
}

