/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl;

import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.camera.core.impl.AutoValue_EncoderProfilesProxy_AudioProfileProxy;
import androidx.camera.core.impl.AutoValue_EncoderProfilesProxy_ImmutableEncoderProfilesProxy;
import androidx.camera.core.impl.AutoValue_EncoderProfilesProxy_VideoProfileProxy;
import com.google.auto.value.AutoValue;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@RequiresApi(value=21)
public interface EncoderProfilesProxy {
    public static final int CODEC_PROFILE_NONE = -1;

    public int getDefaultDurationSeconds();

    public int getRecommendedFileFormat();

    @NonNull
    public List<AudioProfileProxy> getAudioProfiles();

    @NonNull
    public List<VideoProfileProxy> getVideoProfiles();

    @NonNull
    public static String getVideoCodecMimeType(int codec) {
        switch (codec) {
            case 1: {
                return "video/3gpp";
            }
            case 2: {
                return "video/avc";
            }
            case 5: {
                return "video/hevc";
            }
            case 4: {
                return "video/x-vnd.on2.vp8";
            }
            case 3: {
                return "video/mp4v-es";
            }
            case 6: {
                return "video/x-vnd.on2.vp9";
            }
            case 7: {
                return "video/dolby-vision";
            }
            case 8: {
                return "video/av01";
            }
        }
        return "video/none";
    }

    @NonNull
    public static String getAudioCodecMimeType(int codec) {
        switch (codec) {
            case 3: 
            case 4: 
            case 5: {
                return "audio/mp4a-latm";
            }
            case 1: {
                return "audio/3gpp";
            }
            case 2: {
                return "audio/amr-wb";
            }
            case 7: {
                return "audio/opus";
            }
            case 6: {
                return "audio/vorbis";
            }
        }
        return "audio/none";
    }

    public static int getRequiredAudioProfile(int codec) {
        switch (codec) {
            case 3: {
                return 2;
            }
            case 5: {
                return 39;
            }
            case 4: {
                return 5;
            }
        }
        return -1;
    }

    @AutoValue
    public static abstract class VideoProfileProxy {
        public static final String MEDIA_TYPE_NONE = "video/none";
        public static final int BIT_DEPTH_8 = 8;
        public static final int BIT_DEPTH_10 = 10;

        @NonNull
        public static VideoProfileProxy create(int codec, @NonNull String mediaType, int bitrate, int frameRate, int width, int height, int profile, int bitDepth, int chromaSubsampling, int hdrFormat) {
            return new AutoValue_EncoderProfilesProxy_VideoProfileProxy(codec, mediaType, bitrate, frameRate, width, height, profile, bitDepth, chromaSubsampling, hdrFormat);
        }

        public abstract int getCodec();

        @NonNull
        public abstract String getMediaType();

        public abstract int getBitrate();

        public abstract int getFrameRate();

        public abstract int getWidth();

        public abstract int getHeight();

        public abstract int getProfile();

        public abstract int getBitDepth();

        public abstract int getChromaSubsampling();

        public abstract int getHdrFormat();

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface VideoEncoder {
        }
    }

    @AutoValue
    public static abstract class AudioProfileProxy {
        public static final String MEDIA_TYPE_NONE = "audio/none";

        @NonNull
        public static AudioProfileProxy create(int codec, @NonNull String mediaType, int bitRate, int sampleRate, int channels, int profile) {
            return new AutoValue_EncoderProfilesProxy_AudioProfileProxy(codec, mediaType, bitRate, sampleRate, channels, profile);
        }

        public abstract int getCodec();

        @NonNull
        public abstract String getMediaType();

        public abstract int getBitrate();

        public abstract int getSampleRate();

        public abstract int getChannels();

        public abstract int getProfile();

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface AudioEncoder {
        }
    }

    @AutoValue
    public static abstract class ImmutableEncoderProfilesProxy
    implements EncoderProfilesProxy {
        @NonNull
        public static ImmutableEncoderProfilesProxy create(int defaultDurationSeconds, int recommendedFileFormat, @NonNull List<AudioProfileProxy> audioProfiles, @NonNull List<VideoProfileProxy> videoProfiles) {
            return new AutoValue_EncoderProfilesProxy_ImmutableEncoderProfilesProxy(defaultDurationSeconds, recommendedFileFormat, Collections.unmodifiableList(new ArrayList<AudioProfileProxy>(audioProfiles)), Collections.unmodifiableList(new ArrayList<VideoProfileProxy>(videoProfiles)));
        }
    }
}

