/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl;

import android.hardware.camera2.CaptureResult;
import android.util.Pair;
import android.util.Size;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.camera.core.CameraInfo;
import androidx.camera.core.impl.Config;
import androidx.camera.core.impl.OutputSurfaceConfiguration;
import androidx.camera.core.impl.RequestProcessor;
import androidx.camera.core.impl.RestrictedCameraControl;
import androidx.camera.core.impl.SessionConfig;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

@RequiresApi(value=21)
public interface SessionProcessor {
    @NonNull
    public SessionConfig initSession(@NonNull CameraInfo var1, @NonNull OutputSurfaceConfiguration var2);

    public void deInitSession();

    public void setParameters(@NonNull Config var1);

    public void onCaptureSessionStart(@NonNull RequestProcessor var1);

    public void onCaptureSessionEnd();

    public int startRepeating(@NonNull CaptureCallback var1);

    public void stopRepeating();

    public int startCapture(boolean var1, @NonNull CaptureCallback var2);

    public void abortCapture(int var1);

    default public int startTrigger(@NonNull Config config, @NonNull CaptureCallback callback) {
        return -1;
    }

    @NonNull
    default public Map<Integer, List<Size>> getSupportedPostviewSize(@NonNull Size captureSize) {
        return Collections.emptyMap();
    }

    @NonNull
    @RestrictedCameraControl.CameraOperation
    default public Set<Integer> getSupportedCameraOperations() {
        return Collections.emptySet();
    }

    @Nullable
    default public Pair<Long, Long> getRealtimeCaptureLatency() {
        return null;
    }

    public static interface CaptureCallback {
        default public void onCaptureStarted(int captureSequenceId, long timestamp) {
        }

        default public void onCaptureProcessStarted(int captureSequenceId) {
        }

        default public void onCaptureFailed(int captureSequenceId) {
        }

        default public void onCaptureSequenceCompleted(int captureSequenceId) {
        }

        default public void onCaptureSequenceAborted(int captureSequenceId) {
        }

        default public void onCaptureCompleted(long timestamp, int captureSequenceId, @NonNull Map<CaptureResult.Key, Object> result) {
        }

        default public void onCaptureProcessProgressed(int progress) {
        }
    }
}

