/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.extensions;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.camera.core.CameraSelector;
import androidx.camera.core.ImageCapture;
import androidx.camera.extensions.ExtensionVersion;
import androidx.camera.extensions.ExtensionsManager;
import androidx.camera.extensions.ImageCaptureExtender;
import androidx.camera.extensions.impl.AutoImageCaptureExtenderImpl;
import androidx.camera.extensions.impl.ImageCaptureExtenderImpl;

public class AutoImageCaptureExtender
extends ImageCaptureExtender {
    private static final String TAG = "AutoICExtender";

    public static AutoImageCaptureExtender create(ImageCapture.Builder builder) {
        if (ExtensionVersion.isExtensionVersionSupported()) {
            try {
                return new VendorAutoImageCaptureExtender(builder);
            }
            catch (NoClassDefFoundError e) {
                Log.d((String)TAG, (String)"No auto image capture extender found. Falling back to default.");
            }
        }
        return new DefaultAutoImageCaptureExtender();
    }

    private AutoImageCaptureExtender() {
    }

    static class VendorAutoImageCaptureExtender
    extends AutoImageCaptureExtender {
        private final AutoImageCaptureExtenderImpl mImpl = new AutoImageCaptureExtenderImpl();

        VendorAutoImageCaptureExtender(ImageCapture.Builder builder) {
            this.init(builder, (ImageCaptureExtenderImpl)this.mImpl, ExtensionsManager.EffectMode.AUTO);
        }
    }

    static class DefaultAutoImageCaptureExtender
    extends AutoImageCaptureExtender {
        DefaultAutoImageCaptureExtender() {
        }

        @Override
        public boolean isExtensionAvailable(@NonNull CameraSelector selector) {
            return false;
        }

        @Override
        public void enableExtension(@NonNull CameraSelector selector) {
        }
    }
}

