/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.extensions;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.camera.core.CameraSelector;
import androidx.camera.core.Preview;
import androidx.camera.extensions.ExtensionVersion;
import androidx.camera.extensions.ExtensionsManager;
import androidx.camera.extensions.PreviewExtender;
import androidx.camera.extensions.impl.BeautyPreviewExtenderImpl;
import androidx.camera.extensions.impl.PreviewExtenderImpl;

public class BeautyPreviewExtender
extends PreviewExtender {
    private static final String TAG = "BeautyPreviewExtender";

    public static BeautyPreviewExtender create(Preview.Builder builder) {
        if (ExtensionVersion.isExtensionVersionSupported()) {
            try {
                return new VendorBeautyPreviewExtender(builder);
            }
            catch (NoClassDefFoundError e) {
                Log.d((String)TAG, (String)"No beauty preview extender found. Falling back to default.");
            }
        }
        return new DefaultBeautyPreviewExtender();
    }

    private BeautyPreviewExtender() {
    }

    static class VendorBeautyPreviewExtender
    extends BeautyPreviewExtender {
        private final BeautyPreviewExtenderImpl mImpl = new BeautyPreviewExtenderImpl();

        VendorBeautyPreviewExtender(Preview.Builder builder) {
            this.init(builder, (PreviewExtenderImpl)this.mImpl, ExtensionsManager.EffectMode.BEAUTY);
        }
    }

    static class DefaultBeautyPreviewExtender
    extends BeautyPreviewExtender {
        DefaultBeautyPreviewExtender() {
        }

        @Override
        public boolean isExtensionAvailable(@NonNull CameraSelector selector) {
            return false;
        }

        @Override
        public void enableExtension(@NonNull CameraSelector selector) {
        }
    }
}

