/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.extensions;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.core.impl.CameraFilter;
import androidx.camera.core.impl.CameraInternal;
import androidx.camera.extensions.CameraUtil;
import androidx.camera.extensions.impl.ImageCaptureExtenderImpl;
import androidx.camera.extensions.impl.PreviewExtenderImpl;
import java.util.LinkedHashSet;
import java.util.Set;

public final class ExtensionCameraFilter
implements CameraFilter {
    private PreviewExtenderImpl mPreviewExtenderImpl;
    private ImageCaptureExtenderImpl mImageCaptureExtenderImpl;

    ExtensionCameraFilter(@Nullable PreviewExtenderImpl previewExtenderImpl) {
        this.mPreviewExtenderImpl = previewExtenderImpl;
        this.mImageCaptureExtenderImpl = null;
    }

    ExtensionCameraFilter(@Nullable ImageCaptureExtenderImpl imageCaptureExtenderImpl) {
        this.mPreviewExtenderImpl = null;
        this.mImageCaptureExtenderImpl = imageCaptureExtenderImpl;
    }

    ExtensionCameraFilter(@Nullable PreviewExtenderImpl previewExtenderImpl, @Nullable ImageCaptureExtenderImpl imageCaptureExtenderImpl) {
        this.mPreviewExtenderImpl = previewExtenderImpl;
        this.mImageCaptureExtenderImpl = imageCaptureExtenderImpl;
    }

    @NonNull
    public Set<CameraInternal> filterCameras(@NonNull Set<CameraInternal> cameras) {
        LinkedHashSet<CameraInternal> resultCameras = new LinkedHashSet<CameraInternal>();
        for (CameraInternal camera : cameras) {
            String cameraId = camera.getCameraInfoInternal().getCameraId();
            boolean available = true;
            if (this.mPreviewExtenderImpl != null) {
                available = this.mPreviewExtenderImpl.isExtensionAvailable(cameraId, CameraUtil.getCameraCharacteristics(cameraId));
            }
            if (this.mImageCaptureExtenderImpl != null) {
                available = this.mImageCaptureExtenderImpl.isExtensionAvailable(cameraId, CameraUtil.getCameraCharacteristics(cameraId));
            }
            if (!available) continue;
            resultCameras.add(camera);
        }
        return resultCameras;
    }
}

