/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.extensions;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.camera.core.CameraSelector;
import androidx.camera.core.ImageCapture;
import androidx.camera.extensions.ExtensionVersion;
import androidx.camera.extensions.ExtensionsManager;
import androidx.camera.extensions.ImageCaptureExtender;
import androidx.camera.extensions.impl.HdrImageCaptureExtenderImpl;
import androidx.camera.extensions.impl.ImageCaptureExtenderImpl;

public class HdrImageCaptureExtender
extends ImageCaptureExtender {
    private static final String TAG = "HdrImageCaptureExtender";

    public static HdrImageCaptureExtender create(ImageCapture.Builder builder) {
        if (ExtensionVersion.isExtensionVersionSupported()) {
            try {
                return new VendorHdrImageCaptureExtender(builder);
            }
            catch (NoClassDefFoundError e) {
                Log.d((String)TAG, (String)"No HDR image capture extender found. Falling back to default.");
            }
        }
        return new DefaultHdrImageCaptureExtender();
    }

    private HdrImageCaptureExtender() {
    }

    static class VendorHdrImageCaptureExtender
    extends HdrImageCaptureExtender {
        private final HdrImageCaptureExtenderImpl mImpl = new HdrImageCaptureExtenderImpl();

        VendorHdrImageCaptureExtender(ImageCapture.Builder builder) {
            this.init(builder, (ImageCaptureExtenderImpl)this.mImpl, ExtensionsManager.EffectMode.HDR);
        }
    }

    static class DefaultHdrImageCaptureExtender
    extends HdrImageCaptureExtender {
        DefaultHdrImageCaptureExtender() {
        }

        @Override
        public boolean isExtensionAvailable(@NonNull CameraSelector selector) {
            return false;
        }

        @Override
        public void enableExtension(@NonNull CameraSelector selector) {
        }
    }
}

